/*
** D4DEMO3.C
**
** The SoftC Database Library
**
** Copyright (C) 1995, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include "dblib.h"

int iDBF, iMDX, iLoop;
long lRecNo, lTag;
char szKey[21], szName[21], szDate[9];
double dQuantity;
char *pName[] = { "Marc", "Robert", "Ashley", "Amelia", "Shellyne" };
double pQuantity[5] = { 100, 10, 50, 36, 91 };
char *pDate[] = { "05/05/95", "07/22/95", "04/12/95", "03/24/95", "05/29/95" };

DBFIELD Fields[] = { { "NAME",     'C', 10, 0 },
                     { "QUANTITY", 'N',  3, 0 },
                     { "DATE",     'D',  8, 0 } };
void main( void )
{
   DBInitialize( 20, 0 );

   DBCreateFile( "EXAMPLE.DBF", 3, Fields, DBDBASE4|DBPRODUCTIONINDEX );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBDBASE4 );

   DBCreateIndex( "EXAMPLE.MDX", 1, DBDBASE4 );
   DBOpenIndex( &iMDX, "EXAMPLE.MDX", DBOPENSTANDARD|DBDBASE4 );

   for( iLoop = 0; iLoop < 5; iLoop++ )
   {
      DBPutNamedData( iDBF, "NAME", pName[ iLoop ] );
      DBPutNamedData( iDBF, "QUANTITY", &pQuantity[ iLoop ] );
      DBPutNamedData( iDBF, "DATE", pDate[ iLoop ] );
      DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   }

   DBBuildTag( iDBF, iMDX, "NAME", DBCHARACTERKEY, "NAME", 10, 0, NULL, NULL, 0 );
   DBBuildTag( iDBF, iMDX, "QUANTITY", DBNUMERICKEY, "QUANTITY", 8, 0, NULL, NULL, 0 );
   DBBuildTag( iDBF, iMDX, "DATE", DBDATEKEY, "DATE", 8, 0, NULL, NULL, 0 );

   printf( "Sorted by name..\n" );

   DBOpenNamedTag( &lTag, iMDX, "NAME" );
   DBGoFirstKey( lTag, szKey, &lRecNo );

   while( DBGetErrorCode() == DBSUCCESS )
   {
      DBGetRecord( iDBF, lRecNo );

      DBGetNamedData( iDBF, "NAME", szName );
      DBGetNamedData( iDBF, "QUANTITY", &dQuantity );
      DBGetNamedData( iDBF, "DATE", szDate );
      printf( "%s %3.0f %s\n", szName, dQuantity, szDate );

      DBGoNextKey( lTag, szKey, &lRecNo );
   }

   printf( "\nSorted by quantity..\n" );

   DBCloseTag( lTag );

   DBOpenNamedTag( &lTag, iMDX, "QUANTITY" );
   DBGoFirstKey( lTag, szKey, &lRecNo );

   while( DBGetErrorCode() == DBSUCCESS )
   {
      DBGetRecord( iDBF, lRecNo );

      DBGetNamedData( iDBF, "NAME", szName );
      DBGetNamedData( iDBF, "QUANTITY", &dQuantity );
      DBGetNamedData( iDBF, "DATE", szDate );
      printf( "%s %3.0f %s\n", szName, dQuantity, szDate );

      DBGoNextKey( lTag, szKey, &lRecNo );
   }

   printf( "\nSorted by date..\n" );

   DBCloseTag( lTag );

   DBOpenNamedTag( &lTag, iMDX, "DATE" );
   DBGoFirstKey( lTag, szKey, &lRecNo );

   while( DBGetErrorCode() == DBSUCCESS )
   {
      DBGetRecord( iDBF, lRecNo );

      DBGetNamedData( iDBF, "NAME", szName );
      DBGetNamedData( iDBF, "QUANTITY", &dQuantity );
      DBGetNamedData( iDBF, "DATE", szDate );
      printf( "%s %3.0f %s\n", szName, dQuantity, szDate );

      DBGoNextKey( lTag, szKey, &lRecNo );
   }

   DBCloseIndex( iMDX );
   DBCloseFile( iDBF );
   DBTerminate();
}
