/*
** L1DEM008.C
**
** The SoftC Database Library
**
** Copyright (C) 1995, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include "dblib.h"

DBFIELD Field[] = { { "FNAME", 'C', 10, 0 },
                    { "LNAME", 'C', 10, 0 } };

long lRecNo, lNDX;
int iDBF, iNDX, iLoop;
char szKey[21];
char *pFNames[] = { "Marc", "Billy", "Tom", "Lucy", "Ruby" };
char *pLNames[] = { "Leger", "McDaniel", "Adams", "Adams", "Crawford" };

void main( void )
{
   DBInitialize( 20, 0 );
   DBCreateFile( "EXAMPLE.DBF", 2, Field, DBDBASE3 );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBDBASE3 );

   for( iLoop = 0; iLoop < 5; iLoop++ )
   {
      printf( "Name added: %s %s\n", pFNames[ iLoop ], pLNames[ iLoop ] );

      DBPutFieldData( iDBF, 0, pFNames[ iLoop ] );
      DBPutFieldData( iDBF, 1, pLNames[ iLoop ] );
      DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   }

   DBCreateIndex( "EXAMPLE.NDX", 1, DBDBASE3 );
   DBOpenIndex( &iNDX, "EXAMPLE.NDX", DBOPENSTANDARD|DBDBASE3 );

   DBBuildTag( iDBF, iNDX, "EXAMPLE", DBCHARACTERKEY,
      "UPPER(LNAME)+UPPER(FNAME)", 20, 0, NULL, NULL, 0 );

   DBOpenTag( &lNDX, iNDX, 0 );

   DBGoFirstKey( lNDX, szKey, &lRecNo );

   puts( "" );

   while( DBGetErrorCode() == DBSUCCESS )
   {
      printf( "Key: %ld %s\n", lRecNo, szKey );
      DBGoNextKey( lNDX, szKey, &lRecNo );
   }

   DBCloseIndex( iNDX );
   DBCloseFile( iDBF );
   DBTerminate();
}

