/*
** L1DEM005.C
**
** The SoftC Database Library
**
** Copyright (C) 1995, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include "dblib.h"

long lRecNo, lNTX;
int iLoop, iDBF, iNTX;
char szKey[11], szName[11];
char *pNames[] = { "Marc", "Todd", "Angie", "Jones", "Jones", "Jones",
                      "Jones", "Mark", "Sharon", "Steve"   };
double dAges[10] = { 25, 34, 33, 41, 23, 27, 38, 31, 26, 45 }, dAge;

DBFIELD Fields[] = { { "NAME", 'C', 10, 0 },
                     { "AGE",  'N',  2, 0 } };

void main( void )
{
   DBInitialize( 20, 0 );

   DBCreateFile( "EXAMPLE.DBF", 2, Fields, DBCLIPPER5 );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBCLIPPER5 );

   DBCreateIndex( "EXAMPLE.NTX", 1, DBCLIPPER5 );
   DBOpenIndex( &iNTX, "EXAMPLE.NTX", DBOPENSTANDARD|DBCLIPPER5 );
   DBCreateTag( iNTX, "EXAMPLE", DBCHARACTERKEY, "NAME", 10, 0, NULL );
   DBOpenTag( &lNTX, iNTX, 0 );

   for( iLoop = 0; iLoop < 10; iLoop++ )
   {
      DBPutFieldData( iDBF, 0, pNames[ iLoop ] );
      DBPutFieldData( iDBF, 1, &dAges[ iLoop ] );
      DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );

      DBInsertKey( lNTX, pNames[ iLoop ], lRecNo );
   }

   DBGoFirstKey( lNTX, szKey, &lRecNo );

   while( DBGetErrorCode() != DBNOMOREKEYS )
   {
      printf( "Key stored: %2ld %s\n", lRecNo, szKey );
      DBGoNextKey( lNTX, szKey, &lRecNo );
   }

   strcpy( szKey, "Jones" );
   DBKeySearch( lNTX, szKey, &lRecNo, DBKEYEQUAL|DBCONTINUE );

   puts( "" );

   for ( ;; )
   {
      DBGetRecord( iDBF, lRecNo );
      DBGetFieldData( iDBF, 0, szName );
      DBGetFieldData( iDBF, 1, &dAge );

      printf( "Name: %s Age: %2.0f\n", szName, dAge );

      if( DBGoNextKey( lNTX, szKey, &lRecNo ) )
         break;
   }

   DBCloseFile( iDBF );
   DBCloseIndex( iNTX );
   DBTerminate();
}
