/*
** L1DEM004.C
**
** The SoftC Database Library
**
** Copyright (C) 1995, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include "dblib.h"

long lRecNo, lNTX;
int iLoop, iDBF, iNTX;
char szKey[4], szName[11];
char *pNames[] = { "Marc", "Todd", "Angie", "Lyn", "Robert", "Amie",
                   "Shellye", "Mark", "Sharon", "Steve"   };
double dAges[10] = { 25, 30, 33, 41, 30, 27, 38, 30, 26, 45 }, dKey, dAge;

DBFIELD Fields[] = { { "NAME", 'C', 10, 0 },
                     { "AGE",  'N',  2, 0 } };

void main( void )
{
   DBInitialize( 20, 0 );

   DBCreateFile( "EXAMPLE.DBF", 2, Fields, DBCLIPPER5 );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBCLIPPER5 );

   DBCreateIndex( "EXAMPLE.NTX", 1, DBCLIPPER5 );
   DBOpenIndex( &iNTX, "EXAMPLE.NTX", DBOPENSTANDARD|DBCLIPPER5 );
   DBCreateTag( iNTX, "EXAMPLE", DBNUMERICKEY, "AGE", 2, 0, NULL );
   DBOpenTag( &lNTX, iNTX, DBCLIPPER5 );

   for( iLoop = 0; iLoop < 10; iLoop++ )
   {
      DBPutFieldData( iDBF, 0, pNames[ iLoop ] );
      DBPutFieldData( iDBF, 1, &dAges[ iLoop ] );
      DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );

      DBNumericToKey( lNTX, szKey, dAges[ iLoop ] );
      DBInsertKey( lNTX, szKey, lRecNo );
   }

   DBGoFirstKey( lNTX, szKey, &lRecNo );

   while( DBGetErrorCode() != DBNOMOREKEYS )
   {
      DBKeyToNumeric( lNTX, &dKey, szKey );
      printf( "Key stored: %2ld %2.0f\n", lRecNo, dKey );
      DBGoNextKey( lNTX, szKey, &lRecNo );
   }

   DBNumericToKey( lNTX, szKey, 30 );
   DBKeySearch( lNTX, szKey, &lRecNo, DBKEYEQUAL|DBCONTINUE );

   puts( "" );

   for ( ;; )
   {
      DBGetRecord( iDBF, lRecNo );
      DBGetFieldData( iDBF, 0, szName );
      DBGetFieldData( iDBF, 1, &dAge );

      printf( "Name: %s Age: %2.0f\n", szName, dAge );

      if( DBGoNextKey( lNTX, szKey, &lRecNo ) )
         break;
   }

   DBCloseFile( iDBF );
   DBCloseIndex( iNTX );
   DBTerminate();
}
