	.386p        
	.model small

include  dispatch.ase 
include  prints.ase 
include  mtrap.ase 
include  regs.ase 
include  dump.ase 
include  entry.ase 
include  exec.ase 
include  breaks.ase 
include  dis.ase 

	PUBLIC	qerr, ReadNumber, ReadAddress, InputHandler
	PUBLIC	WadeSpace, PageTrapErr, PageTrapUnerr, GetInputLine
	extrn put_msg:proc, __rexit

	extrn put_char : proc, get_char : proc
IBSIZE = 80

	.data
oldpagetrap	df	0		; Temp store for user page trap
inputbuffer db	IBSIZE DUP (?)		; Input buffer
commands db	"bdegpqrtu"		; List of commands
comlen	= $ - commands			; Length of list
prompt	db	10,13,"* ",0		; MONITOR prompt
InvalidPaging db 10,13,"Invalid paging",0	; Message for page trap

	.code
;
; Print an error if command wrong
;
qerr	PROC	
	mov	ebx,offset CRLF
	call	put_msg
	sub	esi,offset inputbuffer-2; Calculate error pos
	mov	ecx,esi			;
	jcxz	short qestart		;
	dec	ecx			;
	jcxz	short qestart		;
qelp:					
	call	printspace              ; Space over to error pos
     	loop	qelp
qestart:
	mov	dl,'^'			; Display error
	call	put_char
	stc				; Did an error
	ret	
qerr	ENDP	
;
; If paging traps, it comes here
;
PageTrapped	PROC	
	mov	esp,[rtoss]		;
	call	PageTrapUnerr		; Turn page trap off
	mov	ebx,offset InvalidPaging
	call	put_msg
	jmp	InputHandler		; Go do more input
PageTrapped	ENDP	
;
; Set up monitor page trap error
;
PageTrapErr	PROC	
	pusha
	mov 	bl,14			; get user trap vect
	mov 	ax,204h
	int	31h
	
	mov	DWORD PTR [oldpagetrap],edx;
	mov	WORD PTR [oldpagetrap + 4],cx;
	mov	ecx,cs			; Set MONITOR trap interrupt
	mov	edx,offset PageTrapped	;
	mov	ax,205h
	int 	31h
	popa
	ret
PageTrapErr	ENDP	
;
; Set user page trap error ( unset monitor error)
;
PageTrapUnerr	PROC	
	pusha
	mov	edx,DWORD PTR [oldpagetrap]	; Restore user value
	mov	cx,WORD PTR [oldpagetrap + 4]	;
	mov	ax,205h
	int 	31h
	popa
	ret
PageTrapUnerr	ENDP	
;
; Read in a number
;
ReadNumber	PROC	
	push	ebx
	sub	ebx,ebx			; Number = 0
	push	ecx
	push	edx
	sub	ecx,ecx			; digits = 0
rnlp:
	lodsb				; Get char & convert to uppercase
	cmp	al,60h
	jc	notlower
	and	al,NOT 20h
notlower:
	sub	al,'0'    		; Convert to binary
	jc	short rn_done		; < '0' is an error
	cmp	al,10			; See if is a digit
	jc	short gotdigit		; Yes, got it
	sub	al,7			; Convert letters to binary
	cmp	al,16			; Make sure is < 'G'
	jnc	short rn_done		; Quit if not
	cmp	al,10			; MAke sure not < 'A'
	jc	short rn_done
gotdigit:
	shl	ebx,4			; It is a hex digit, add in
	or	bl,al			;
	inc	ecx			; Set flag to indicate we got digits
	jmp	rnlp
rn_done:
	dec	esi			; Point at first non-digit
	test	cl,-1			; See if got any
	jnz	gotnum			;
	stc				; No, error
gotnum:
	pop	edx
	pop	ecx
	mov	eax,ebx
	pop	ebx
	ret	
ReadNumber	ENDP	
;
; Read an address, composed of a number and a possible selector
;
ReadAddress	PROC	
	call	ReadNumber		; Read in offset
	jc	short raerr		; Quit if error
	mov	ebx,eax			;
gotaddr:
	clc				; OK, exit
	ret
raerr:
	stc				; Error on number input
	ret
ReadAddress	ENDP	
;
; Get an input line
;
GetInputLine	PROC	
	mov	edi,offset inputbuffer	; Get input buffer
	mov	esi,edi			; Return buffer pointer
	mov	ecx,IBSIZE		; Size of buffer
moreinput:
	call	get_char
	cmp	al,8			; Is delete or rubout?
	jz	short bkspc		; Yes - go do it
	cmp	al,7fh			;
	jz	short bkspc		; yes - go do it
	stosb
	cmp	al,13			; Is CR
	jz	short endinput		; Yes, return
	loop	moreinput		; Loop till buffer full
endinput:
	ret
bkspc:
	cmp	edi,offset inputbuffer	; Quit if nothing in buffer
	jz	moreinput		; And get more input
	mov	dl,' '			;
	call	put_char
	mov	dl,8			; Reset pointer
	call	put_char
	dec	edi			; Point at last char
	jmp	moreinput		; Get more input
GetInputLine	ENDP	
;
; Wade pasth spaces
;
WadeSpace	PROC	
	lodsb				; Get char
	cmp	al,' '			; if ' ' or ',' go again
	jz	short WadeSpace		;
	cmp	al,','			;
	jz	short WadeSpace		;
	dec	esi			; Point at last space char
	ret
WadeSpace	ENDP	
;
; Main Input routine
;
InputHandler	PROC	
	mov	ebx,offset prompt
	call	put_msg
	call	GetInputLine		; Get an input line
	call	WadeSpace		; Wade through spaces
	cmp	al,13			; Go again if nothing typed
	jz	InputHandler		;
	inc	esi			; Point at first non-space char
	mov	edi,offset commands	; Get command list
	mov	ecx,comlen		; Length of list
	repne	scasb			;
	jnz	ierr			; Error if not in list
	mov	eax,comlen-1		; Calculate position
	sub	eax,ecx			;
	push	0			; command arg = 0
	call	TableDispatch		; Dispatch command
	dd	comlen-1
	dd	breaks
	dd	dump
	dd	entry
	dd	go
	dd	proceed
	dd	__rexit
	dd	ModifyRegisters
	dd	trap
	dd	diss
	jnc	InputHandler		; Get more input if no err
ierr:
	call	qerr			; Display error
	jmp	InputHandler		; Get more input
InputHandler	ENDP	
END