char *loaders_rcs = "$Id: loaders.c,v 1.4 1997/04/20 17:10:39 ACJC Exp $";
/* Written and copyright by the Anonymous Coders and Junkbusters Corporation.
 * Will be made available under the GNU General Public License.
 * This software comes with NO WARRANTY.
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <string.h>
#include <malloc.h>
#include <errno.h>
#include <sys/stat.h>
#include <ctype.h>

#ifdef REGEX
#include <regex.h>
#endif

#include "jcc.h"

void
unload_url(struct url_spec *url)
{
	if(url->spec)	free(url->spec);	url->spec   = NULL;
	if(url->domain)	free(url->domain);	url->domain = NULL;
	if(url->dvec)	free(url->dvec);	url->dvec   = NULL;
	if(url->path)	free(url->path);	url->path   = NULL;
#ifdef REGEX
	if(url->preg)	free(url->preg);	url->preg   = NULL;
#endif
}

void
unload_blockfile(struct block_spec *b)
{
	if(b == NULL) return;

	unload_blockfile(b->next);

	unload_url(b->url);

	free(b);
}

void
unload_cookiefile(struct cookie_spec *b)
{
	if(b == NULL) return;

	unload_cookiefile(b->next);

	unload_url(b->url);

	free(b);
}

int
load_blockfile()
{
	FILE *fp;

	struct block_spec *b;
	char  buf[BUFSIZ], *p, *q;
	char *tmp_vec[BUFSIZ];
	int port, n, reject;
	static struct textlist t[1];
	static struct stat prev[1], curr[1];

	if(stat(blockfile, curr) < 0) {
		goto load_blockfile_error;
	}

	if(prev->st_mtime == curr->st_mtime) {
		return(0);
	}

	*prev = *curr;

	if(t->text) {
		t->text[0] = '\0';	/* realloc() will reclaim the space */
	} else {
		add_proxy_args(t);
	}

	unload_blockfile(blist->next);

	blist->next = 0;

	if((fp = fopen(blockfile, "r")) == NULL) {
		goto load_blockfile_error;
	}

	
	sprintf(buf, "<h2>The file `%s' contains the following patterns</h2>\n", blockfile);
	po(t, 0, buf);

#ifdef REGEX
	po(t, 0, "# this Junkbuster supports POSIX regular expressions in the path specs.");
#endif

	while(fgets(buf, sizeof(buf), fp)) {

		po(t, 0, buf);

		if((p = strpbrk(buf, "\r\n")) == NULL) {
			errno = EINVAL;
			fclose(fp);
			goto load_blockfile_error;
		}

		*p = '\0';

		/* comments */
		if((p = strchr(buf, '#'))) *p = '\0';

		/* elide white-space */
		for(p = q = buf; *q ; q++) {
			if(!isspace(*q)) *p++ = *q;
		}

		*p = '\0';

		reject = 1;

		if(*buf == '~') {
			reject = 0;
			p = buf;
			q = p+1;
			while (*p++ = *q++) {
				/* nop */
			}
		}

		/* skip blank lines */
		if(*buf == '\0') continue;

		/* allocate a new node */
		if(((b       = malloc(sizeof(*b)))       == NULL)
#ifdef REGEX
		|| ((b->url->preg = malloc(sizeof(*b->url->preg))) == NULL)
#endif
		) {
			fclose(fp);
			goto load_blockfile_error;
		}

		/* add it to the list */
		b->next     = blist->next;
		blist->next = b;

		/* save a copy of the orignal specification */
		if((b->url->spec = strdup(buf)) == NULL) {
			fclose(fp);
			goto load_blockfile_error;
		}

		b->reject = reject;

		if((p = strchr(buf, '/'))) {
			b->url->path    = strdup(p);
			b->url->pathlen = strlen(b->url->path);
			*p = '\0';
		} else {
			b->url->path    = NULL;
			b->url->pathlen = 0;
		}
#ifdef REGEX
		if(b->url->path) {
			int errcode;
			char rebuf[BUFSIZ];

			sprintf(rebuf, "^(%s)", b->url->path);

			errcode = regcomp(b->url->preg, rebuf,
					(REG_EXTENDED|REG_NOSUB|REG_ICASE));
			if(errcode) {
				size_t errlen =
					regerror(errcode,
						b->url->preg, buf, sizeof(buf));

				buf[errlen] = '\0';

				fprintf(log,
					"%s: error compiling %s: %s\n",
						prog, b->url->spec, buf);
				fclose(fp);
				goto load_blockfile_error;
			}
		}
#endif
		if((p = strchr(buf, ':')) == NULL) {
			port = 0;
		} else {
			*p++ = '\0';
			port = atoi(p);
		}

		b->url->port = port;

		if((b->url->domain = strdup(buf)) == NULL) {
			fclose(fp);
			goto load_blockfile_error;
		}

		/* split domain into components */
		b->url->dcnt = dsplit(b->url->domain, tmp_vec);

		/* save them */
		n = b->url->dcnt * sizeof(b->url->dvec[0]);
		b->url->dvec  = (char **)malloc(n);
		memcpy(b->url->dvec, tmp_vec, n);
	}

	fclose(fp);

	return(0);

load_blockfile_error:
	fprintf(log, "%s: can't load blockfile '%s': ",
		prog, blockfile);
	fperror(log, "");
	return(-1);
}

int
load_cookiefile()
{
	FILE *fp;

	struct cookie_spec *b;
	char  buf[BUFSIZ], *p, *q;
	char *tmp_vec[BUFSIZ];
	int port, n, user_cookie, server_cookie;
	static struct textlist t[1];
	static struct stat prev[1], curr[1];

	if(stat(cookiefile, curr) < 0) {
		goto load_cookie_error;
	}

	if(prev->st_mtime == curr->st_mtime) {
		return(0);
	}

	*prev = *curr;

	if(t->text) {
		t->text[0] = '\0';	/* realloc will reclaim the space */
	} else {
		add_proxy_args(t);
	}

	unload_cookiefile(clist->next);

	clist->next = NULL;
	
	if((fp = fopen(cookiefile, "r")) == NULL) {
		goto load_cookie_error;
	}

	sprintf(buf, "<h2>The file `%s' contains the following patterns</h2>\n", cookiefile);
	po(t, 0, buf);

#ifdef REGEX
	po(t, 0, "# this Junkbuster supports POSIX regular expressions in the cookie specs.");
#endif

	while(fgets(buf, sizeof(buf), fp)) {

		po(t, 0, buf);

		if((p = strpbrk(buf, "\r\n")) == NULL) {
			errno = EINVAL;
			fclose(fp);
			goto load_cookie_error;
		}

		*p = '\0';

		/* comments */
		if((p = strchr(buf, '#'))) *p = '\0';

		/* elide white-space */
		for(p = q = buf; *q ; q++) {
			if(!isspace(*q)) *p++ = *q;
		}

		*p = '\0';

		p = buf;

		switch((int)*p) {
		case '>':
			server_cookie = 0;
			user_cookie   = 1;
			p++;
			break;
		case '<':
			server_cookie = 1;
			user_cookie   = 0;
			p++;
			break;
		case '~':
			server_cookie = 0;
			user_cookie   = 0;
			p++;
			break;
		default:
			server_cookie = 1;
			user_cookie   = 1;
			break;
		}

		/* elide any of the "special" chars from the
		 * front of the pattern
		 */
		q = buf;
		if(p > q) while (*q++ = *p++) {
			/* nop */
		}

		/* skip blank lines */
		if(*buf == '\0') continue;

		/* allocate a new node */
		if(((b       = malloc(sizeof(*b)))       == NULL)
#ifdef REGEX
		|| ((b->url->preg = malloc(sizeof(*b->url->preg))) == NULL)
#endif
		) {
			fclose(fp);
			goto load_cookie_error;
		}

		/* add it to the list */
		b->next     = clist->next;
		clist->next = b;

		/* save a copy of the orignal specification */
		if((b->url->spec = strdup(buf)) == NULL) {
			fclose(fp);
			goto load_cookie_error;
		}

		b->send_user_cookie     = user_cookie;
		b->accept_server_cookie = server_cookie;

		if((p = strchr(buf, '/'))) {
			b->url->path    = strdup(p);
			b->url->pathlen = strlen(b->url->path);
			*p = '\0';
		} else {
			b->url->path    = NULL;
			b->url->pathlen = 0;
		}
#ifdef REGEX
		if(b->url->path) {
			int errcode;
			char rebuf[BUFSIZ];

			sprintf(rebuf, "^(%s)", b->url->path);

			errcode = regcomp(b->url->preg, rebuf,
					(REG_EXTENDED|REG_NOSUB|REG_ICASE));
			if(errcode) {
				size_t errlen =
					regerror(errcode,
						b->url->preg, buf, sizeof(buf));

				buf[errlen] = '\0';

				fprintf(log,
					"%s: error compiling %s: %s\n",
						prog, b->url->spec, buf);
				fclose(fp);
				goto load_cookie_error;
			}
		}
#endif
		if((p = strchr(buf, ':')) == NULL) {
			port = 0;
		} else {
			*p++ = '\0';
			port = atoi(p);
		}

		b->url->port = port;

		if((b->url->domain = strdup(buf)) == NULL) {
			fclose(fp);
			goto load_cookie_error;
		}

		/* split domain into components */
		b->url->dcnt = dsplit(b->url->domain, tmp_vec);

		/* save them */
		n = b->url->dcnt * sizeof(b->url->dvec[0]);
		b->url->dvec  = (char **)malloc(n);
		memcpy(b->url->dvec, tmp_vec, n);
	}

	fclose(fp);

	return(0);

load_cookie_error:
	fprintf(log, "%s: can't load cookiefile '%s': ",
		prog, cookiefile);
	fperror(log, "");
	return(-1);
}

#define JUNKBUSTERS "http://www.junkbusters.com"
#define OPT "href=\"" JUNKBUSTERS "/ht/en/ijbman.html#o_"

void
po(struct textlist *t, int c, char *s)
{
	char buf[BUFSIZ], *p;
	char *curbuf = t->text;
	int old_len, new_len;

	*buf = '\0';

	if(c) sprintf(buf, "-<a " OPT "%c\">%c</a> ", c, c);

	if(s) strcat(buf, s);
	strcat(buf, "<br>\n");

	if(curbuf) {
		old_len = strlen(curbuf);
	} else {
		old_len = 0;
	}

	new_len = old_len + strlen(buf) + 1;

	if(curbuf) {
		if((p = realloc(curbuf, new_len)) == NULL) {
			fprintf(log, "%s: realloc(%d) bytes for proxy_args failed!\n", prog, new_len);
			exit(1);
		}
	} else {
		if((p = malloc(new_len)) == NULL) {
			fprintf(log, "%s: malloc(%d) bytes for proxy_args failed!\n", prog, new_len);
			exit(1);
		}
		*p = '\0';
	}

	strcpy(p + old_len, buf);

	t->text = p;
}

struct textlist *
init_proxy_args()
{
	char buf[BUFSIZ];
	char *b = buf;
	static struct textlist t[1];

	add_proxy_args(t);

	strcpy(b,
		"HTTP/1.0 200 OK\n"
		"Server: " VERSION "\n"
		"Content-type: text/html\n\n"

		"<html>"
		"<head>"
		"<title>Internet Junkbuster Proxy Status</title>"
		"</head>\n"
		"<body bgcolor=\"#f8f8f0\" link=\"#000078\" alink=\"#ff0022\" vlink=\"#787878\">\n"
		"<center>\n"
		"<h1>Internet J<small>UNK<i><font color=red>BUSTER</font></i>\n"
		"<a href=\"" JUNKBUSTERS "/ht/en/ijbfaq.html#show\">Proxy Status</a>\n"
		"</small></h1></center>\n"
		"<h2>You are using the Internet Junkbuster <sup><small><small>TM</small></small></sup></h2>\n"
		"Version: " VERSION "\n"
		"<p>\n"
	);

	b = b + strlen(buf);

	strcat(b, "<h2>The program was invoked as follows</h2>\n");

	b += strlen(b);

	sprintf(b, "%s<br>\n", prog      ); b += strlen(b);

	t->text = strdup(buf);

	return(t);
}

struct textlist *
end_proxy_args()
{
	char buf[2048];
	char *b = buf;
	static struct textlist t[1];
	extern char	*bind_rcs, *conn_rcs, *encode_rcs,
			*jcc_rcs, *loaders_rcs, *parsers_rcs,
			*socks4_rcs, *ssplit_rcs;

	add_proxy_args(t);

	strcpy(b, "<h2>Source versions:</h2>\n");	b += strlen(b);
	sprintf(b, "%s<br>\n", jcc_rcs    );		b += strlen(b);
	sprintf(b, "%s<br>\n", parsers_rcs);		b += strlen(b);
	sprintf(b, "%s<br>\n", loaders_rcs);		b += strlen(b);
	sprintf(b, "%s<br>\n", conn_rcs   );		b += strlen(b);
	sprintf(b, "%s<br>\n", bind_rcs   );		b += strlen(b);
	sprintf(b, "%s<br>\n", encode_rcs );		b += strlen(b);
	sprintf(b, "%s<br>\n", socks4_rcs );		b += strlen(b);
	sprintf(b, "%s<br>\n", ssplit_rcs );		b += strlen(b);

	strcpy(b,
		"<small><small><p>\n"
		"Code and documentation of the Internet Junkbuster Proxy"
		"<sup><small>TM</small></sup>\n"
		"<a href=\""  JUNKBUSTERS "/legal.html#copy\">\n" "Copyright</a>&#169; 1997 Junkbusters Corporation\n"
		"<a href=\"" JUNKBUSTERS "/legal.html#marks\"><sup><small>TM</small></sup></a><br>\n"
		"Copying and distribution permitted under the"
		"<a href=\""  JUNKBUSTERS "/gpl.html\">\n"
		"<small>GNU</small></a> "
		"General Public License.\n"
		"</small>"
		"<address><kbd>webmaster@junkbusters.com</kbd></address>"
		"</small>"
		"</body></html>\n"
	);

	t->text = strdup(buf);
	return(t);
}

int
show_proxy_args(char *buf, int bufsiz)
{
	char *s = buf;
	struct textlist *p;

	*s = '\0';

	bufsiz -= 1;	/* save space for the NULL */

	for(p = proxy_args->next; p ; p = p->next) {
		int n = strlen(p->text);

		if(n > bufsiz) n = bufsiz;

		strncpy(s, p->text, n);
		s += n;
	}

	*s = '\0';

	return(strlen(buf));
}

void
add_loader(int (*loader)())
{
	int i;

	for(i=0; i < NLOADERS; i++) {
		if(loaders[i] == NULL) {
			loaders[i] = loader;
			break;
		}
	}
}

int
run_loader()
{
	int ret = 0;
	int i;

	for(i=0; i < NLOADERS; i++) {
		if(loaders[i] == NULL) break;
		ret |= (loaders[i])();
	}
	return(ret);
}

void
add_proxy_args(struct textlist *t)
{
	struct textlist *p = proxy_args;

	while(p->next) p = p->next;

	p->next = t;
}
