#ifndef __LIBX_H__
#define __LIBX_H__
/*
 * $Id: libx.h,v 1.14 1995/07/03 16:23:07 edvkai Exp $
 *
 *	libx.h
 * Some extended library functions.
 *
 * $Log: libx.h,v $
 * Revision 1.14  1995/07/03  16:23:07  edvkai
 * Big pipe.
 *
 * Revision 1.13  1995/04/26  12:11:38  edvkai
 * decompress_compare
 *
 * Revision 1.12  1995/04/18  13:11:37  edvkai
 * Compression routines.
 *
 * Revision 1.11  1994/08/18  13:24:46  edvkai
 * EMX has getpass in unistd.h
 *
 * Revision 1.10  1994/08/01  13:01:48  edvkai
 * Removed declaration of alloca.
 *
 * Revision 1.9  1993/12/08  13:59:15  edvkai
 * Removed false RCSids from log.
 *
 * Revision 1.8  1993/09/20  13:10:15  edvkai
 * *** empty log message ***
 *
 * Revision 1.7  1993/07/30  13:07:08  edvkai
 * searchpath2.
 *
 * Revision 1.6  1993/02/19  17:12:18  edvrei
 * added getproctype()
 *
 * Revision 1.5  1992/06/01  15:37:54  hsv
 * prototype for lmuladddiv()
 *
 * Revision 1.4  1992/02/14  18:09:40  ak
 * *** empty log message ***
 *
 * Revision 1.3  1992/01/03  14:21:21  ak
 *
 * Revision 1.2  1992/01/03  13:46:12  ak
 * Zortech fixes.
 *
 * Revision 1.1.1.1  1991/12/12  16:11:28  ak
 * Initial checkin of server source, modified to contain RCS IDs.
 *
 * Revision 1.1  1991/12/12  16:11:23  ak
 * Initial revision
 *
 */

#ifndef __STAT_H__
  /* need typedef FileStat */
# include <sys/types.h>
# include <sys/stat.h>
#endif

#if defined(__TURBOC__)
# include <dir.h>
#elif (defined(MICROSOFT) || defined(__ZTC__)) && !defined(OS2)
# include <dos.h>
# include <tccmsc.h>
#endif

#include <param.h>

#ifdef __cplusplus
   extern "C" {
#endif

void	filename (const char *, char *, char *, char *, int);
int	fmatch   (const char *, const char *);	/* (string, pattern) */
				/* OS/2: not case sensitive ! */

#define F_HIDDEN  0x02
#define F_SYSTEM  0x04
#define F_VOLUME  0x08
#define F_SUBDIR  0x10
#define F_REGULAR 0x20
int	setmatch (const char *, int);
char *	getmatch (void);

#ifdef __ZTC__
int _pascal
#else
int
#endif
	response_expand (int *, char ***);	/* (&argc, &argv) */
void	expand_argv (int *, char ***);		/* (&argc, &argv) */

int	index (int, char *);

#ifndef __TURBOC__
char *	searchpath (char *);
char *	searchpath2 (char *, char *);
#endif

#ifndef OS2

typedef struct DScan {
	char		*ds_name;
	struct ffblk	ds_ffb;
	struct stat	ds_fstat;
	char		ds_first;	/* first scan */
} DScan;

int	setdscan (char * /*path*/, DScan * /*dsp*/);/* -> 0 if no files */
int	setalldscan (char * /*path*/, DScan * /*dsp*/);	/* -> 0 if no files */
	/* all files inclusive HIDDEN and SYSTEM */

char	*nxtdscan (DScan * /*dsp*/); 		/* -> *filename */

int	setgenv (const char *);	/* set global environment */
				/* returns 0 on success, -1 on error */

#endif /*OS2*/

#ifdef __ZTC__
 #if __ZTC__ < 0x210
  int	fdopen(int, char *);
  int	dup(int);
  int	dup2(int,int);
 #endif
 int	ioctl(int, int, ...);
#endif

char *	mktemp(char *);
int	mkstemp(char *);

#ifndef __TURBOC__
#ifndef __EMX__
char *	getpass (char *prompt);			/* read invisible password */
#endif
#endif

	/* MicroEMACS encryption: */
void	crypte (char *buffer, unsigned length);	/* initialize: (NULL, method) */
	/* DES encryption: */
char *	crypt (char *key, char *salt);		/* key = char[64] of 0,1 */
						/* returns encrypted key */
void	setkey (char *key);			/* key = char[64] of 0,1 */
						/* set key for encrypt() */
void	encrypt (char *block, int decrypt);	/* key = char[64] of 0,1 */
						/* encryps/decryps block */

#ifndef __EMX__
char *	_getdcwd (int drive, char *buf, int buflen);
char *	getcwd (char *buf, int buflen);
char *	getwd (char *buf);
int	_chddir (char *dir);			/* change disk & dir */
#endif

long	lmuladddiv(long m1, long m2, long a, long d);
		/* -> (64bit)(l1 * l2 + a) / d
		   with 64 bit intermediate result
		   ONLY for 32bit CPU's */

int	compress_block (unsigned char **src, int slen, unsigned char *dst, int dlen);
int	decompress_block (unsigned char *src, int slen, unsigned char *dst, int dlen);
int	compress_file (int fd, unsigned char *dst, int dlen);
long	decompress_file (int fd, unsigned char *src, int slen);
long	decompress_compare (int fd, unsigned char *src, int slen);

/* args: -s<size>, -b<reblock>, -i<ifill%>, -o<ofill%>, see "buffer" */
void *	pipe_buffer (int rfd, int wfd, char **argv); /* return handle */
void *	pipe_start (int fds[2], char **argv); /* return handle */
int	pipe_end (void *handle, int abortf); /* return 0 or errno */
		   
/* Process Type codes */
#define PT_FULLSCREEN		0 /* Full screen application		*/
#define PT_REALMODE		1 /* Real mode process			*/
#define PT_WINDOWABLEVIO	2 /* VIO windowable application 	*/
#define PT_PM			3 /* Presentation Manager application	*/
#define PT_DETACHED		4 /* Detached application		*/
int	getproctype(void);

#ifdef __cplusplus
   }
#endif

#endif

