/* ndc.cmd



   A ReXX version of ndc for the OS/2 port of bind.

   using emxkill to send signals to named

*/



kill = '@emxkill'



PIDFILE = value('ETC',,'OS2ENVIRONMENT')||'\named.pid'


parse upper arg command



if (command = 'HELP') then signal USAGE

if ((arg() = 0)|(strip(command) = '')) then signal USAGE

pid = strip(linein( PIDFILE ))

if (command = 'START') then do
	if (stream( PIDFILE, 'c', 'query exists') = '') then do
		'@detach named -c'||value('ETC',,'OS2ENVIRONMENT')||'\named.conf'
		say 'Name server started'
		return
	end
	else signal alreadyrunning
end

if (command = 'STATUS') then do
	if (stream( PIDFILE, 'c', 'query exists') = '') then
		say 'named is not running'
	else
		say 'named is running (PID 'pid')'
	return
end

if (stream( PIDFILE, 'c', 'query exists') = '') then signal notfound

rc = stream( PIDFILE, 'c', 'close' )	/* Important for the restart command, where we'll call ourselves */


select

	when (command = 'STOP')

		then do

			kill '9' pid	/* SIGKILL */

			say 'Name Server Stopped'
			'@del' PIDFILE '>nul'	/* Make sure(?) PIDFILE is removed */

		end

	when (command = 'RESTART')
		then do
     			call 'ndc' 'stop'	/* Calling ourself to do the dirty work... */
			call RxFuncAdd'SysSleep', 'RexxUtil', 'SysSleep'	/* Loading function while we're waiting anyway */
			call SysSleep 5		/* Sleeping 5 seconds before attempting to restart */
			call 'ndc' 'start'	/* Calling ourself to do the dirty work... */
		end /* do */
	when (command = 'DUMPDB')

		then do 

			kill '2' pid	/* SIGINT */

			say 'Dumping Database'

		end

	when (command = 'RELOAD')

		then do 

			kill '1' pid	/* SIGHUP */

			say 'Reloading Database'

		end

	when (command = 'STATS')

		then do 

			kill '4' pid	/* SIGILL */

			say 'Dumping Statistics'

		end

	when (command = 'TRACE')

		then do 

			kill '16' pid	/* SIGUSR1 */

			say 'Trace Level Incremented'

		end

	when (command = 'NOTRACE')

		then do 

			kill '17' pid	/* SIGUSR2 */

			say 'Tracing Cleared'

		end

	when (command = 'QUERYLOG')|(command = 'QRYLOG')

		then do 

			kill '20' pid	/* SIGWINCH */

			say 'Query Logging Toggled'

		end

	otherwise

		signal USAGE

end	/* select */

return


USAGE:
 say

 say 'usage: ndc (status|dumpdb|reload|stats|trace|notrace|querylog|start|stop|restart)'

 say

 exit



notfound:

 say

 say 'PID file "'PIDFILE'" not found. Is named running?'

 say

 exit



alreadyrunning:
 say
 say 'ndc: start: named (pid 'pid') already running'
 say
 exit

