@echo off

REM This program launches DOOM II. Lets you, on the command line, 
REM choose which map to start on, skill and which wadfile(s) to 
REM load. Is to be used together with the program ENTER.COM.

REM Author:     Magnus Ander 
REM Email:      m94man@student.tdb.uu.se
REM             m96maa@student.docs.uu.se
REM             paranoia@[194.22.170.29]
             
REM Date: May the 8th 1997

REM The 1st argument (%1) is the mapnumber (1 - 32).
REM The 2nd argument (%2) is the skill (1 - 5).
REM Give the wadfiles as a set of arguments with the first 
REM giving the directory where the wadfiles are stored.



REM You must give at least three arguments!
if "%3"=="" goto help
if not exist %3\nul goto continue

REM If the third argument is a directory, there must be a fourth!
if "%4"=="" goto help

REM The number of arguments was OK, continue!
:continue
set warp=-warp %1
set skill=-skill %2

REM Tell DOOM II to load each wadfile given on the command line.
shift
set files=-file
:makefileoption
  shift
  if "%1"=="" goto stop
  if not exist %1\nul goto isfile 
  set dirname=%1\
  shift
  if exist %1\nul goto help
  if "%1"=="" goto help
  :isfile
  if not exist %dirname%%1 goto ferror
  set files=%files% %dirname%%1
goto makefileoption 
:stop

REM Start DOOM II at the given level and with the given skill.
enter
doom2 %files% %warp% %skill%
goto delete

REM The given wadfile does not exist!
:ferror
  echo.
  echo Error - The file "%dirname%%1" does not exist!
  echo.

REM Delete every environment variable used.
:delete
  set warp=
  set skill=
  set files=
  set dirname=
goto end

REM The number of arguments was not enough, show some help.
:help
  echo.
  echo syntax: PLAY map skill ((wadfile or {directory wadfile ...}) ...)
  echo.

REM End of program.
:end
