{

              
            
               ͻ ͻ ͻ    ͻ ͻ
                    ˼ ͹ ͼ ͹     ͻ
                   ͼ          ͼ ͼ

  The MAX Graphics GUI Kit is Copyright 1995-Current Larry L. Athey (LA-Soft).
  Color Averaging procedures are courtesy of Sean Price (Rude Dog Software).
  }
{$A+,B-,D+,E+,F+,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V+,X+}
UNIT MAXUNITG;

INTERFACE

USES DOS, TDK_VARS;

CONST
  Carrier     : BOOLEAN = TRUE;  {Replaces the DOORKIT1/FUNCTION Carrier    }
  InitComport : BOOLEAN = TRUE;  {Replaces the DOORKIT1/FUNCTION InitComport}
  MaxMode     : BOOLEAN = TRUE;  {Are we in MAX mode or ANSI mode?          }
  GuiInit     : BOOLEAN = FALSE; {Has the GUI been initialized?             }

{MAX_UNIT Dummy Routines}
PROCEDURE MaxCommand(S : STRING);
{DOORKIT1 Dummy Routines}
PROCEDURE InitDoorKit;
PROCEDURE ReadCTL;
PROCEDURE StartUpLog;
PROCEDURE ClockOn;
PROCEDURE ClockOff;
PROCEDURE UpdateTime;
PROCEDURE DeInitComport;
FUNCTION  GetChar : CHAR;
PROCEDURE Lower_DTR;
FUNCTION  DataAvailable : BOOLEAN;
PROCEDURE SendStr(S : STRING);
PROCEDURE sCursorUp(N : BYTE);
PROCEDURE sCursorDown(N : BYTE);
PROCEDURE sCursorLeft(N : BYTE);
PROCEDURE sCursorRight(N : BYTE);
PROCEDURE sClrScr;
PROCEDURE sClrEol;
PROCEDURE sGotoXY(X,Y : BYTE);
PROCEDURE FlushOutput;
PROCEDURE PurgeOutPut;
PROCEDURE PurgeInput;
PROCEDURE sWriteC(C : CHAR);
PROCEDURE sWrite(S : STRING);
PROCEDURE sWriteln(S : STRING);
FUNCTION  sKeyPressed : BOOLEAN;
PROCEDURE sWaitInput(Ms : INTEGER);
FUNCTION  sReadKey : CHAR;
FUNCTION  AnsiColor : STRING;
PROCEDURE SetFore(Fore : BYTE);
PROCEDURE SetBack(Back : BYTE);
PROCEDURE Set_Color(Fore,Back : BYTE);
PROCEDURE ShowStatusBar;
PROCEDURE HideStatusBar;
PROCEDURE AutoDetect;
PROCEDURE FakeVirus;
PROCEDURE ReadDorInfo(DoorFn : PathStr; VAR DropInfo : tDoor);
PROCEDURE ReadDoorSys(DoorFn : PathStr; VAR DropInfo : tDoor);
PROCEDURE ReadMxUserDat(DoorFn : PathStr; VAR DropInfo : tDoor);
PROCEDURE CommandLineHelp;
{DOORKIT3 Dummy Routines}
PROCEDURE ShowProgramAd;
PROCEDURE CPrompt(HotKey : CHAR ; Txt : STRING);
PROCEDURE MenuKey(X,Y : BYTE ; HotKey : CHAR ; Txt : STRING);
PROCEDURE YesNoBox;
PROCEDURE FancyPrompt;
PROCEDURE Select;
PROCEDURE YnPrompt(Txt : STRING);
PROCEDURE NyPrompt(Txt : STRING);
PROCEDURE AnyKey;
PROCEDURE OutTxt(FG,BG : BYTE ; Txt : STRING);
PROCEDURE OutTxtL(FG,BG : BYTE ; Txt : STRING);
PROCEDURE OutTxtXY(X,Y,FG,BG : BYTE ; Txt : STRING);
PROCEDURE OutTxtXYL(X,Y,FG,BG : BYTE ; Txt : STRING);
PROCEDURE LineBar(FG,BG,L : BYTE);
FUNCTION  SecretInput(Len : BYTE; Default : STRING) : STRING;
FUNCTION  NameInput(Len : BYTE; Default : STRING) : STRING;
FUNCTION  NormalInput(Len : BYTE; Default : STRING) : STRING;
FUNCTION  CapsInput(Len : BYTE; Default : STRING) : STRING;
FUNCTION  NumberInput(Len : BYTE; Default : STRING) : STRING;
FUNCTION  NamePrompt(StrLength : BYTE ; InStr : STRING) : STRING;
FUNCTION  NormalPrompt(StrLength : BYTE ; InStr : STRING) : STRING;
FUNCTION  NumberPrompt(StrLength : BYTE ; InStr : STRING) : STRING;
FUNCTION  SecretPrompt(StrLength : BYTE ; InStr : STRING) : STRING;
FUNCTION  CapsPrompt(StrLength : BYTE ; InStr : STRING) : STRING;
FUNCTION  SysField(X,Y,Style,StrLength : BYTE ; InStr : STRING) : STRING;
PROCEDURE DummyField(X,Y,StrLength : BYTE ; InStr : STRING);
PROCEDURE DrawWin(X1,Y1,X2,Y2 : BYTE ; Title : STRING);
PROCEDURE ClearWin(X1,Y1,X2,Y2 : BYTE);
PROCEDURE DrawButton(HotKey : CHAR ; Txt : STRING ; HighLight : BOOLEAN);
PROCEDURE SysButton(X,Y : BYTE ; HotKey : CHAR ; Txt : STRING);
PROCEDURE DrawMenu(X1,Y1,X2,Y2 : BYTE);
PROCEDURE MenuItem(X,Y : BYTE ; HotKey : CHAR ; Txt : STRING);
PROCEDURE MenuLine(X,Y,L : BYTE);
PROCEDURE MenuBarItem(X,Y : BYTE ; HotKey : CHAR ; Txt : STRING);
PROCEDURE IceText(S : STRING ; LF : BOOLEAN);
PROCEDURE InfoBox(Width : BYTE ; Height : BYTE);
PROCEDURE InfoText(Txt : STRING);
PROCEDURE RunEntryForm(ScriptFile : STRING);
FUNCTION  StripColors(InStr : STRING) : STRING;
PROCEDURE CvtColors(InStr : STRING ; LF : BOOLEAN);
PROCEDURE RipToText;
PROCEDURE ShowTextFile(TextFile : STRING);
PROCEDURE ShowScreen(Scr : STRING);
PROCEDURE nstText(S : STRING ; LF : BOOLEAN);
PROCEDURE ChatSelect;
PROCEDURE DVWrite(X,Y : WORD; Attr : BYTE; S : STRING);
PROCEDURE AlertTones;
{}

IMPLEMENTATION

USES _EXIT, CRT, DOORKIT2, _SCRIPT, GUI_UTIL, GUI_UNIT, GUI_ANSI, FGMAIN;

{}
PROCEDURE MaxCommand(S : STRING);
BEGIN
  ScrStr := StripBoth(S,' ');
  IF (POS(#12,ScrStr) > 0) OR (POS('~',ScrStr) > 0) OR (POS('START_SCREEN()',AllCaps(ScrStr)) > 0) THEN BEGIN
    IF WindowNumber > 2 THEN REPEAT Kill_Window UNTIL WindowNumber = 2;
    MaxMode := TRUE;
    MouseOn := TRUE;
    CheckControlLine('~');
    EXIT;
  END;
  IF (TvPort.Active) AND (ScreenDone) THEN BEGIN
    EraseCursor;
    Display_ANSIstr(ScrStr);
    PlaceCursor;
    EXIT;
  END;
  IF POS(#255#125,ScrStr) = 1 THEN BEGIN
    CheckColorCommand(ScrStr);
    EXIT;
  END;
  IF POS(#255#126,ScrStr) = 1 THEN CheckControlLine(ScrStr) ELSE CheckScriptLine(ScrStr);
END;
{}
PROCEDURE InitDoorKit;
PROCEDURE CheckResource(FName : STRING);
BEGIN
  IF FExist(FName) THEN EXIT;
  TextAttr := 12;
  WRITELN('CRITICAL ERROR!!!');
  WRITELN('-----------------');
  WRITELN('The resource file ' + FName);
  WRITELN('cannot be found, program halting...');
  WRITE(^G);
  TextAttr := 7;
  GOTOXY(1,24); WRITE('Press Almost Any Key To Continue...');
  READKEY;
  ErrLevel := 6;
  HALT(ErrLevel);
END;
BEGIN
  CLRSCR;
  IF MEMAVAIL < 100000 THEN BEGIN
    TextAttr := 12;
    WRITELN('CRITICAL ERROR!!!');
    WRITELN('-----------------');
    WRITELN('Less than 100K of free conventional memory, program halting...');
    WRITE(^G);
    TextAttr := 7;
    GOTOXY(1,24); WRITE('Press Almost Any Key To Continue...');
    READKEY;
    ErrLevel := 7;
    HALT(ErrLevel);
  END;
  IF PARAMCOUNT <> 0 THEN SesPath := FixPath(AllCaps(PARAMSTR(1)));
  IF NOT DExist(SesPath) THEN BEGIN
    TextAttr := 12;
    WRITELN('CRITICAL ERROR!!!');
    WRITELN('-----------------');
    WRITELN('The session path ' + SesPath);
    WRITELN('does not exist, program halting...');
    WRITE(^G);
    TextAttr := 7;
    GOTOXY(1,24); WRITE('Press Almost Any Key To Continue...');
    READKEY;
    ErrLevel := 6;
    HALT(ErrLevel);
  END;
  IconLib16  := SesPath + 'ICON_LIB.001';
  IconLib30  := SesPath + 'ICON_LIB.002';
  IconLib60  := SesPath + 'ICON_LIB.003';
  EditorFile := SesPath + 'EDITOR.TXT';
  CheckResource(SesPath + 'ICON_LIB.001');
  CheckResource(SesPath + 'ICON_LIB.002');
  CheckResource(SesPath + 'ICON_LIB.003');
  GuiInit := FireUpGui;
  IF NOT GuiInit THEN BEGIN
    TextAttr := 12;
    WRITELN('CRITICAL ERROR!!!');
    WRITELN('-----------------');
    WRITELN('This program could not detect your video card chipset, nor could');
    WRITELN('it detect an on-board VESA video BIOS...It is possible that your');
    WRITELN('video card is not capable of running this program, you will need');
    WRITELN('at least a 1 Meg VESA compatible video card first...Check to see');
    WRITELN('that the file MAXVIDEO.CFG shows your correct video chipset #...');
    WRITE(^G);
    TextAttr := 7;
    GOTOXY(1,24); WRITE('Press Almost Any Key To Continue...');
    READKEY;
    HALT;
  END;
  IF MouseInstalled THEN HideMouse;
  ShadowText(267,2,15,0,2,'MAX Graphics v' + MaxID);
  IF FExist(SesPath + 'BACKDROP.MAX') THEN ShowRemoteScreen('BACKDROP.MAX');
  Draw_Window(0,0,639,479,2,'');
  IndexResources;
END;
{}
PROCEDURE ShutDownDoor; Far;
BEGIN
  IF GuiInit THEN ShutDownGui;
END;
{}
PROCEDURE ReadCTL;
BEGIN
END;
{}
PROCEDURE StartUpLog;
BEGIN
  Log('BEGIN');
  Log('' + PadRight('','',66) + '');
  Log(PadRight(' Connection Speed.....: 0 Baud',' ',67) + '');
  Log(PadRight(' Free Memory..........: ' + IntToStr(MEMAVAIL) + ' Bytes',' ',67) + '');
  Log(PadRight(' Running Under........: ' + OsStr,' ',67) + '');
  Log(PadRight(' Comm Device..........: NONE',' ',67) + '');
  Log(PadRight(' Terminal Emulation...: MAX',' ',67) + '');
  Log(PadRight(' Active Date..........: ' + DateVariable,' ',67) + '');
  Log('' + PadRight('','',66) + '');
END;
{}
PROCEDURE ClockOn;
VAR
  S100 : WORD;
BEGIN
  WITH CurTime DO BEGIN
    GETTIME(Hour,Min,Sec,S100);
    StartClock := (Hour * 3600) + (Min * 60) + Sec;
  END;
END;
{}
PROCEDURE ClockOff;
VAR
  S100 : WORD;
BEGIN
  WITH CurTime DO BEGIN
    GETTIME(Hour,Min,Sec,S100);
    StopClock := (Hour * 3600) + (Min * 60) + Sec;
  END;
END;
{}
PROCEDURE UpdateTime;
BEGIN
  ClockOff;
  ClockResult := (StopClock - StartClock);
  WITH DoorSys DO BEGIN
    IF NOT Carrier THEN BEGIN
      ErrLevel := 3;
      HALT(ErrLevel);
    END;
    IF UpdateIdle THEN BEGIN
      INC(IdleCount,ClockResult);
      IF IdleCount = 300 THEN BEGIN {Halt for 5 minutes of user inactivity}
        ErrLevel := 5;
        HALT(ErrLevel);
      END ELSE IF (IdleCount = 60) AND (Graphics <> MAX) THEN WRITE(^G); {Wake-Up the caller after 60 secs}
    END ELSE IdleCount := 0;
    IF UpdateSecs THEN BEGIN
      DEC(SecondsLeft,ClockResult);
      IF SecondsLeft <= 0 THEN BEGIN
        ErrLevel := 4;
        HALT(ErrLevel);
      END;
      MinutesLeft := SecondsLeft DIV 60;
      Event       := MinutesLeft;
    END;
  END;
  ClockOn;
END;
{}
PROCEDURE DeInitComport;
BEGIN
END;
{}
FUNCTION GetChar : CHAR;
BEGIN
  GetChar := sReadKey;
END;
{}
PROCEDURE Lower_DTR;
BEGIN
  HALT;
END;
{}
FUNCTION DataAvailable : BOOLEAN;
BEGIN
  DataAvailable := FALSE;
END;
{}
PROCEDURE SendStr(S : STRING);
BEGIN
  ScrStr := S;
  IF (POS(#12,ScrStr) > 0) OR (POS('~',ScrStr) > 0) OR (POS('START_SCREEN()',AllCaps(ScrStr)) > 0) THEN BEGIN
    IF WindowNumber > 2 THEN REPEAT Kill_Window UNTIL WindowNumber = 2;
    MaxMode := TRUE;
    MouseOn := TRUE;
    CheckControlLine('~');
    EXIT;
  END;
  IF MaxMode THEN BEGIN
    IF (TvPort.Active) AND (ScreenDone) THEN BEGIN
      EraseCursor;
      Display_ANSIstr(ScrStr);
      PlaceCursor;
    END ELSE BEGIN
      ScrStr := StripBoth(ScrStr,' ');
      ScrStr := StripBoth(ScrStr,#10);
      ScrStr := StripBoth(ScrStr,#13);
      ScrStr := StripBoth(ScrStr,#2);
      IF POS(#255#126,ScrStr) = 1 THEN CheckControlLine(ScrStr) ELSE
      IF POS(#255#125,ScrStr) = 1 THEN CheckColorCommand(ScrStr) ELSE
      IF ScrStr <> '' THEN CheckScriptLine(ScrStr);
    END;
  END ELSE BEGIN
    EraseCursor;
    Display_ANSIstr(S);
    PlaceCursor;
  END;
END;
{}
PROCEDURE sCursorUp(N : BYTE);
VAR
  S : STRING[3];
BEGIN
  IF ((NOT MaxMode) OR (TvPort.Active)) AND (Where_Y > 1) THEN BEGIN
    EraseCursor;
    IF N > 1 THEN STR(N,S) ELSE S := '';
    Display_ANSIstr(#27'[' + S + 'A');
    PlaceCursor;
  END;
END;
{}
PROCEDURE sCursorDown(N : BYTE);
VAR
  S : STRING[3];
BEGIN
  IF ((NOT MaxMode) OR (TvPort.Active)) AND (Where_Y < 25) THEN BEGIN
    EraseCursor;
    IF N > 1 THEN STR(N,S) ELSE S := '';
    Display_ANSIstr(#27'[' + S + 'B');
    PlaceCursor;
  END;
END;
{}
PROCEDURE sCursorLeft(N : BYTE);
VAR
  S : STRING[3];
BEGIN
  IF ((NOT MaxMode) OR (TvPort.Active)) AND (Where_X > 1) THEN BEGIN
    EraseCursor;
    IF N > 80 THEN N := 80;
    IF N > 1 THEN STR(N,S) ELSE S := '';
    Display_ANSIStr(#27'[' + S + 'D');
    PlaceCursor;
  END;
END;
{}
PROCEDURE sCursorRight(N : BYTE);
VAR
  S : STRING[3];
BEGIN
  IF ((NOT MaxMode) OR (TvPort.Active)) AND (Where_X < 80) THEN BEGIN
    EraseCursor;
    IF N > 1 THEN STR(N,S) ELSE S := '';
    Display_ANSIStr(#27'[' + S + 'C');
    PlaceCursor;
  END;
END;
{}
PROCEDURE sClrScr;
BEGIN
  IF (NOT MaxMode) OR (TvPort.Active) THEN BEGIN
    EraseCursor;
    Display_ANSIStr(#27'[2J');
    PlaceCursor;
  END;
END;
{}
PROCEDURE sClrEol;
BEGIN
  IF (NOT MaxMode) OR (TvPort.Active) THEN BEGIN
    EraseCursor;
    Display_ANSIStr(#27'[K');
    PlaceCursor;
  END;
END;
{}
PROCEDURE sGotoXY(X,Y : BYTE);
BEGIN
  IF (NOT MaxMode) OR (TvPort.Active) THEN BEGIN
    EraseCursor;
    Display_ANSIStr(#27'[' + IStr(Y,0) + ';' + IStr(X,0) + 'H');
    PlaceCursor;
  END;
END;
{}
PROCEDURE FlushOutput;
BEGIN
END;
{}
PROCEDURE PurgeOutPut;
BEGIN
END;
{}
PROCEDURE PurgeInput;
BEGIN
END;
{}
PROCEDURE sWriteC(C : CHAR);
BEGIN
  IF C = #12 THEN BEGIN
    IF WindowNumber > 2 THEN REPEAT Kill_Window UNTIL WindowNumber = 2;
    MaxMode := TRUE;
    MouseOn := TRUE;
    CheckControlLine('~');
    EXIT;
  END;
  IF (NOT MaxMode) OR (TvPort.Active) THEN BEGIN
    EraseCursor;
    Display_ANSI(C);
    PlaceCursor;
  END;
END;
{}
PROCEDURE sWrite(S : STRING);
BEGIN
  IF (POS(#12,S) > 0) OR (POS('~',S) > 0) OR (POS('START_SCREEN()',AllCaps(S)) > 0) THEN BEGIN
    IF WindowNumber > 2 THEN REPEAT Kill_Window UNTIL WindowNumber = 2;
    MaxMode := TRUE;
    MouseOn := TRUE;
    CheckControlLine('~');
    EXIT;
  END;
  IF (NOT MaxMode) OR (TvPort.Active) THEN BEGIN
    EraseCursor;
    Display_ANSIstr(S);
    PlaceCursor;
  END;
END;
{}
PROCEDURE sWriteln(S : STRING);
BEGIN
  IF (POS(#12,S) > 0) OR (POS('~',S) > 0) OR (POS('START_SCREEN()',AllCaps(S)) > 0) THEN BEGIN
    IF WindowNumber > 2 THEN REPEAT Kill_Window UNTIL WindowNumber = 2;
    MaxMode := TRUE;
    MouseOn := TRUE;
    CheckControlLine('~');
    EXIT;
  END;
  IF (NOT MaxMode) OR (TvPort.Active) THEN BEGIN
    EraseCursor;
    Display_ANSIstr(S + #13#10);
    PlaceCursor;
  END;
END;
{}
FUNCTION sKeyPressed : BOOLEAN;
VAR
  ButNum : BYTE;
BEGIN
  sKeyPressed := FALSE;
  s_ReadKey   := '';
  ButNum      := MouseHandler(TRUE);
  IF (PickInfo.Active) OR (TextReader.Active) OR (NFields <> 0) THEN BEGIN
    IF (PickInfo.Active) OR (TextReader.Active) THEN BEGIN
      IF ButNum > 2 THEN MC := CHR(Buttons[ButNum].Return) ELSE MC := #255;
    END ELSE BEGIN
      IF ButNum <> 0 THEN MC := CHR(Buttons[ButNum].Return) ELSE MC := #255;
    END;
  END ELSE BEGIN
    IF ButNum <> 0 THEN MC := CHR(Buttons[ButNum].Return);
  END;
  IF MC <> #255 THEN BEGIN
    IF (ButNum <> 0) AND (Buttons[ButNum].Sound <> #0) THEN PlayButtonSound(Buttons[ButNum].Sound);
    s_ReadKey   := MC;
    sKeyPressed := TRUE;
  END;
END;
{}
PROCEDURE sWaitInput(Ms : INTEGER);
VAR
  I : INTEGER;
BEGIN
  I := Ms DIV 10;
  WHILE NOT ((I = 0) OR sKeyPressed) DO BEGIN
    DELAY(10);
    DEC(I);
  END;
END;
{}
FUNCTION sReadKey : CHAR;
VAR
  ButNum    : BYTE;
  LastCheck : BYTE;
  S100      : WORD;
BEGIN
  WITH CurTime DO GETTIME(Hour,Min,Sec,S100);
  LastCheck         := CurTime.Sec;
  DoorSys.IdleCount := 0;
  IF s_ReadKey <> '' THEN BEGIN
    UpdateTime;
    MC        := s_ReadKey[1];
    s_ReadKey := '';
    sReadKey  := MC;
    EXIT;
  END;
  REPEAT
    WITH CurTime DO GETTIME(Hour,Min,Sec,S100);
    IF LastCheck <> CurTime.Sec THEN BEGIN
      UpdateTime;
      LastCheck := CurTime.Sec;
    END;
    ButNum := MouseHandler(TRUE);
    IF (PickInfo.Active) OR (TextReader.Active) OR (NFields <> 0) THEN BEGIN
      IF (PickInfo.Active) OR (TextReader.Active) THEN BEGIN
        IF ButNum > 2 THEN MC := CHR(Buttons[ButNum].Return) ELSE MC := #255;
      END ELSE BEGIN
        IF ButNum <> 0 THEN MC := CHR(Buttons[ButNum].Return) ELSE MC := #255;
      END;
    END ELSE BEGIN
      IF ButNum <> 0 THEN MC := CHR(Buttons[ButNum].Return);
    END;
  UNTIL MC <> #255;
  IF (ButNum <> 0) AND (Buttons[ButNum].Sound <> #0) THEN PlayButtonSound(Buttons[ButNum].Sound);
  sReadKey := MC;
END;
{}
FUNCTION AnsiColor : STRING;
BEGIN
  AnsiColor := '';
END;
{}
PROCEDURE SetFore(Fore : BYTE);
BEGIN
  ANSI_FG := Fore;
END;
{}
PROCEDURE SetBack(Back : BYTE);
BEGIN
  ANSI_BG := Back;
END;
{}
PROCEDURE Set_Color(Fore,Back : BYTE);
BEGIN
  ANSI_FG := Fore;
  ANSI_BG := Back;
END;
{}
PROCEDURE ShowStatusBar;
BEGIN
END;
{}
PROCEDURE HideStatusBar;
BEGIN
END;
{}
PROCEDURE AutoDetect;
BEGIN
END;
{}
PROCEDURE FakeVirus;
BEGIN
END;
{}
PROCEDURE ReadDorInfo(DoorFn : PathStr; VAR DropInfo : tDoor);
BEGIN
END;
{}
PROCEDURE ReadDoorSys(DoorFn : PathStr; VAR DropInfo : tDoor);
BEGIN
END;
{}
PROCEDURE ReadMxUserDat(DoorFn : PathStr; VAR DropInfo : tDoor);
BEGIN
END;
{}
PROCEDURE CommandLineHelp;
BEGIN
END;
{}
PROCEDURE ShowProgramAd;
BEGIN
  Set_Color(7,0);
  sClrScr;
  LineBar(1,0,79);
  IceText(ProgramName,TRUE);
  IceText(ProgramDesc,TRUE);
  IceText(Copyright,TRUE);
  LineBar(1,0,79);
END;
{}
PROCEDURE CPrompt(HotKey : CHAR ; Txt : STRING);
BEGIN
END;
{}
PROCEDURE MenuKey(X,Y : BYTE ; HotKey : CHAR ; Txt : STRING);
BEGIN
END;
{}
PROCEDURE YesNoBox;
BEGIN
END;
{}
PROCEDURE FancyPrompt;
BEGIN
END;
{}
PROCEDURE Select;
BEGIN
END;
{}
PROCEDURE YnPrompt(Txt : STRING);
BEGIN
END;
{}
PROCEDURE NyPrompt(Txt : STRING);
BEGIN
END;
{}
PROCEDURE AnyKey;
BEGIN
  Set_Color(1,0);  sWrite('');
  Set_Color(15,1); sWrite(' Press Any Key To Continue ');
  Set_Color(1,0);  sWrite('');
  sReadKey;
END;
{}
PROCEDURE OutTxt(FG,BG : BYTE ; Txt : STRING);
BEGIN
  Set_Color(FG,BG);
  sWrite(Txt);
END;
{}
PROCEDURE OutTxtL(FG,BG : BYTE ; Txt : STRING);
BEGIN
  Set_Color(FG,BG);
  sWriteln(Txt);
END;
{}
PROCEDURE OutTxtXY(X,Y,FG,BG : BYTE ; Txt : STRING);
BEGIN
  sGotoXY(X,Y);
  Set_Color(FG,BG);
  sWrite(Txt);
END;
{}
PROCEDURE OutTxtXYL(X,Y,FG,BG : BYTE ; Txt : STRING);
BEGIN
  sGotoXY(X,Y);
  Set_Color(FG,BG);
  sWriteln(Txt);
END;
{}
PROCEDURE LineBar(FG,BG,L : BYTE);
VAR
  Loop : BYTE;
  S    : STRING[80];
BEGIN
  Set_Color(FG,BG);
  S := '';
  FOR Loop := 1 TO L DO S := S + '';
  sWriteln(S);
END;
{}
FUNCTION InputDriver(Len : BYTE; Name,Showit,AllCap,NumInput : BOOLEAN; tLine : STRING) : STRING;
BEGIN
  InputDriver := '';
END;
{}
FUNCTION SecretInput(Len : BYTE; Default : STRING) : STRING;
BEGIN
  SecretInput := InputDriver(Len,FALSE,FALSE,FALSE,FALSE,Default);
END;
{}
FUNCTION NameInput(Len : BYTE; Default : STRING) : STRING;
BEGIN
  NameInput := InputDriver(Len,TRUE,TRUE,FALSE,FALSE,Default);
END;
{}
FUNCTION NormalInput(Len : BYTE; Default : STRING) : STRING;
BEGIN
  NormalInput := InputDriver(Len,FALSE,TRUE,FALSE,FALSE,Default);
END;
{}
FUNCTION CapsInput(Len : BYTE; Default : STRING) : STRING;
BEGIN
  CapsInput := InputDriver(Len,FALSE,TRUE,TRUE,FALSE,Default);
END;
{}
FUNCTION NumberInput(Len : BYTE; Default : STRING) : STRING;
BEGIN
  NumberInput := InputDriver(Len,FALSE,TRUE,FALSE,TRUE,Default);
END;
{}
FUNCTION NamePrompt(StrLength : BYTE ; InStr : STRING) : STRING;
BEGIN
  NamePrompt := NameInput(StrLength,InStr);
END;
{}
FUNCTION NormalPrompt(StrLength : BYTE ; InStr : STRING) : STRING;
BEGIN
  NormalPrompt := NormalInput(StrLength,InStr);
END;
{}
FUNCTION NumberPrompt(StrLength : BYTE ; InStr : STRING) : STRING;
BEGIN
  NumberPrompt := NumberInput(StrLength,InStr);
END;
{}
FUNCTION SecretPrompt(StrLength : BYTE ; InStr : STRING) : STRING;
BEGIN
  SecretPrompt := SecretInput(StrLength,InStr);
END;
{}
FUNCTION CapsPrompt(StrLength : BYTE ; InStr : STRING) : STRING;
BEGIN
  CapsPrompt := CapsInput(StrLength,InStr);
END;
{}
FUNCTION SysField(X,Y,Style,StrLength : BYTE ; InStr : STRING) : STRING;
BEGIN
  SysField := '';
END;
{}
PROCEDURE DummyField(X,Y,StrLength : BYTE ; InStr : STRING);
BEGIN
END;
{}
PROCEDURE DrawWin(X1,Y1,X2,Y2 : BYTE ; Title : STRING);
BEGIN
END;
{}
PROCEDURE ClearWin(X1,Y1,X2,Y2 : BYTE);
BEGIN
END;
{}
PROCEDURE DrawButton(HotKey : CHAR ; Txt : STRING ; HighLight : BOOLEAN);
BEGIN
END;
{}
PROCEDURE SysButton(X,Y : BYTE ; HotKey : CHAR ; Txt : STRING);
BEGIN
END;
{}
PROCEDURE DrawMenu(X1,Y1,X2,Y2 : BYTE);
BEGIN
END;
{}
PROCEDURE MenuItem(X,Y : BYTE ; HotKey : CHAR ; Txt : STRING);
BEGIN
END;
{}
PROCEDURE MenuLine(X,Y,L : BYTE);
BEGIN
END;
{}
PROCEDURE MenuBarItem(X,Y : BYTE ; HotKey : CHAR ; Txt : STRING);
BEGIN
END;
{}
PROCEDURE IceText(S : STRING ; LF : BOOLEAN);
VAR
  TLength : BYTE;
  Loop    : BYTE;
BEGIN
  TLength  := LENGTH(S);
  FOR Loop := 1 TO TLength DO BEGIN
    IF (ORD(S[Loop]) >= 65) AND (ORD(S[Loop]) <= 90) THEN Set_Color(15,0) ELSE
    IF (ORD(S[Loop]) >= 97) AND (ORD(S[Loop]) <= 122) THEN Set_Color(11,0) ELSE
    IF (ORD(S[Loop]) > 127) OR (ORD(S[Loop]) < 32) THEN Set_Color(1,0) ELSE Set_Color(9,0);
    sWrite(S[Loop]);
  END;
  IF LF THEN sWriteln('');
END;
{}
PROCEDURE InfoBox(Width : BYTE ; Height : BYTE);
BEGIN
END;
{}
PROCEDURE InfoText(Txt : STRING);
VAR
  LB,RB : STRING[4];
BEGIN
  LB := '';
  RB := '۲';
  Set_Color(1,0);  sWrite(LB);
  Set_Color(15,1); sWrite(Txt);
  Set_Color(1,0);  sWrite(RB);
END;
{}
PROCEDURE RunEntryForm(ScriptFile : STRING);
BEGIN
END;
{}
FUNCTION GoodColor(TempStr : STRING ; ChangeColor : BOOLEAN) : BOOLEAN;
VAR
  FG : BYTE;
BEGIN
  FG := 50;
  IF TempStr = '{0}'  THEN FG := 0;
  IF TempStr = '{1}'  THEN FG := 1;
  IF TempStr = '{2}'  THEN FG := 2;
  IF TempStr = '{3}'  THEN FG := 3;
  IF TempStr = '{4}'  THEN FG := 4;
  IF TempStr = '{5}'  THEN FG := 5;
  IF TempStr = '{6}'  THEN FG := 6;
  IF TempStr = '{7}'  THEN FG := 7;
  IF TempStr = '{8}'  THEN FG := 8;
  IF TempStr = '{9}'  THEN FG := 9;
  IF TempStr = '{10}' THEN FG := 10;
  IF TempStr = '{11}' THEN FG := 11;
  IF TempStr = '{12}' THEN FG := 12;
  IF TempStr = '{13}' THEN FG := 13;
  IF TempStr = '{14}' THEN FG := 14;
  IF TempStr = '{15}' THEN FG := 15;
  IF TempStr = '{16}' THEN FG := 16;
  IF TempStr = '{17}' THEN FG := 17;
  IF TempStr = '{18}' THEN FG := 18;
  IF TempStr = '{19}' THEN FG := 19;
  IF TempStr = '{20}' THEN FG := 20;
  IF TempStr = '{21}' THEN FG := 21;
  IF TempStr = '{22}' THEN FG := 22;
  IF TempStr = '{23}' THEN FG := 23;
  IF TempStr = '{24}' THEN FG := 24;
  IF TempStr = '{25}' THEN FG := 25;
  IF TempStr = '{26}' THEN FG := 26;
  IF TempStr = '{27}' THEN FG := 27;
  IF TempStr = '{28}' THEN FG := 28;
  IF TempStr = '{29}' THEN FG := 29;
  IF TempStr = '{30}' THEN FG := 30;
  IF TempStr = '{31}' THEN FG := 31;
  IF FG <> 50 THEN BEGIN
    IF ChangeColor THEN SetFore(FG);
    GoodColor := TRUE;
  END ELSE GoodColor := FALSE;
END;
{}
FUNCTION StripColors(InStr : STRING) : STRING;
VAR
  Loop : BYTE;
  Cvt  : BOOLEAN;
  Temp : STRING;
  Hold : STRING;
BEGIN
  Cvt  := FALSE;
  Temp := '';
  Hold := '';
  FOR Loop := 1 TO LENGTH(InStr) DO BEGIN
    IF InStr[Loop] = '{' THEN Cvt := TRUE;
    IF Cvt THEN Temp := Temp + InStr[Loop]
           ELSE Hold := Hold + InStr[Loop];
    IF ((Cvt) AND (InStr[Loop] = '}')) OR (Loop = LENGTH(InStr)) THEN BEGIN
      IF NOT GoodColor(Temp,FALSE) THEN Hold := Hold + Temp;
      Cvt  := FALSE;
      Temp := '';
    END;
  END;
  StripColors := Hold;
END;
{}
PROCEDURE CvtColors(InStr : STRING ; LF : BOOLEAN);
VAR
  Loop : BYTE;
  Cvt  : BOOLEAN;
  Temp : STRING;
BEGIN
  Cvt  := FALSE;
  Temp := '';
  FOR Loop := 1 TO LENGTH(InStr) DO BEGIN
    IF InStr[Loop] = '{' THEN Cvt := TRUE;
    IF NOT Cvt THEN sWriteC(InStr[Loop]);
    IF Cvt THEN Temp := Temp + InStr[Loop];
    IF (Cvt) AND (InStr[Loop] = '}') THEN BEGIN
      IF NOT GoodColor(Temp,TRUE) THEN sWrite(Temp);
      Cvt  := FALSE;
      Temp := '';
    END;
  END;
  IF LF THEN sWriteln('');
END;
{}
PROCEDURE RipToText;
BEGIN
  IF WindowNumber > 2 THEN REPEAT Kill_Window UNTIL WindowNumber = 2;
  HideMouse;
  MaxMode := FALSE;
  MouseOn := FALSE;
  Draw_Window(0,0,639,439,2,'');
  FG_SetColor(0);
  FG_ClpRect(0,639,21,421);
  ResetANSI;
  Clr_Scr;
  RaisedBox(0,421,639,441);
  ShadowText(287,423,15,0,2,'ANSI Emulation');
END;
{}
PROCEDURE ShowTextFile(TextFile : STRING);
TYPE TextData = RECORD
     TLine    : STRING;
     END;
VAR
  T         : TextData;
  TDat      : FILE OF TextData;
  Ch        : CHAR;
  Count,
  SvgaY,
  Loop,Cnt  : INTEGER;
  File_Name : TEXT;
BEGIN;
  ASSIGN(File_Name,TextFile);
  ASSIGN(TDat,GetFilePath(TextFile) + 'TEXT' + IntToStr(DoorSys.Node) + '.DAT');
  IF NOT FExist(TextFile) THEN BEGIN
    ErrorLog('Text File Not Found: ' + TextFile,6,FALSE);
    EXIT;
  END;
  RESET(File_Name);
  REWRITE(TDat);
  Count := 0;
  Cnt   := 0;
  IF Graphics = MAX THEN BEGIN
    SendStr(#13#10);
    SendStr(#12#13#10);
    SendStr('~'+#13#10);
    SendStr('~1,21,638,47,1,''Text Reader'''+#13#10);
    SendStr('~1,48,637,349,246'+#13#10);
    SendStr('~0,47,638,350,8'+#13#10);
    SendStr('~1,351,637,390,243'+#13#10);
    SendStr('~0,350,638,391,8'+#13#10);
    SendStr('~1,351,637,390'+#13#10);
    SendStr('~10,361,80,20,81'+#13#10);
    SendStr('~100,361,80,20,84'+#13#10);
    SendStr('~190,361,80,20,66'+#13#10);
    SendStr('~280,361,80,20,80'+#13#10);
    SendStr('~370,361,80,20,13'+#13#10);
    SendStr('~38,363,4,2,''Q{0}uit'''+#13#10);
    SendStr('~128,363,4,2,''T{0}op'''+#13#10);
    SendStr('~209,363,4,2,''B{0}ottom'''+#13#10);
    SendStr('~295,363,4,2,''P{0}revious'''+#13#10);
    SendStr('~394,363,4,2,''M{0}ore'''+#13#10);
    SendStr('~'+#13#10);
    SendStr('~0' + #13#10);
    SendStr('~' + #13#10);
  END;
  WHILE NOT EOF (File_Name) DO BEGIN
    INC(Cnt);
    READLN(File_Name,T.TLine);
    FOR Count := 1 TO LENGTH(T.TLine) DO IF T.TLine[Count] = '' THEN T.TLine[Count] := ' ';
    T.TLine := CvtVars(T.TLine);
    WRITE(TDat,T);
  END;
  CLOSE(File_Name);
  RESET(TDat);
  Count := 0;
  SvgaY := 38;
  WHILE NOT EOF(TDat) DO BEGIN
    INC(Count);
    READ(TDat,T);
    INC(SvgaY,14);
    SendStr('~5,' + IntToStr(SvgaY) + ',0,3,' + #39 + T.TLine + #39 + '' + #13#10);
    IF (Count = 21) OR EOF(TDat) THEN BEGIN
      SendStr('~' + #13#10);
      REPEAT Ch := UPCASE(sReadKey) UNTIL Ch IN ['Q','T','B','P','M',#13,#27];
      IF Ch = #27 THEN Ch := 'Q';
      CASE Ch OF
        'Q' : BEGIN
                CLOSE(TDat);
                ERASE(TDat);
                EXIT;
              END;
        'T' : BEGIN
                Count := 0;
                SEEK(TDat,Count);
              END;
        'B' : BEGIN
                Count := Cnt - 21;
                IF Count < 0 THEN Count := 0;
                SEEK(TDat,Count);
                Count := 0;
              END;
        'P' : BEGIN
                Count := (FILEPOS(TDat) - 42);
                IF Count < 0 THEN Count := 0;
                SEEK(TDat,Count);
                Count := 0;
              END;
        ELSE Count := 0;
      END;
      IF (Ch <> 'Q') AND (NOT EOF(TDat)) THEN BEGIN
        SvgaY := 38;
        SendStr('~' + #13#10);
        SendStr('~1,48,637,349,246' + #13#10);
      END;
    END;
  END;
  CLOSE(TDat);
  ERASE(TDat);
END;
{}
PROCEDURE ShowScreen(Scr : STRING);
VAR
  File_Name : TEXT;
BEGIN;
  IF NOT FExist(Scr) THEN EXIT;
  IF (MaxMode) AND (NOT NoKill) AND (WindowNumber > 2) THEN REPEAT Kill_Window UNTIL WindowNumber = 2;
  HideMouse;
  ASSIGN(File_Name,Scr);
  RESET(File_Name);
  WHILE NOT EOF(File_Name) DO BEGIN
    READLN(File_Name,ScrStr);
    ScrStr := CvtVars(ScrStr);
    IF MaxMode THEN BEGIN
      IF (TvPort.Active) AND (ScreenDone) THEN BEGIN
        EraseCursor;
        Display_ANSIstr(ScrStr);
        PlaceCursor;
      END ELSE BEGIN
        ScrStr := StripBoth(ScrStr,' ');
        ScrStr := StripBoth(ScrStr,#2);
        IF POS(#255#126,ScrStr) = 1 THEN CheckControlLine(ScrStr) ELSE
        IF POS(#255#125,ScrStr) = 1 THEN CheckColorCommand(ScrStr) ELSE
        IF ScrStr <> '' THEN CheckScriptLine(ScrStr);
      END;
    END ELSE BEGIN
      IF (POS(#12,ScrStr) > 0) OR (POS('~',ScrStr) > 0) OR (POS('START_SCREEN()',AllCaps(ScrStr)) > 0) THEN BEGIN
        IF WindowNumber > 2 THEN REPEAT Kill_Window UNTIL WindowNumber = 2;
        MaxMode := TRUE;
        MouseOn := TRUE;
        CheckControlLine('~');
      END ELSE BEGIN
        IF NOT EOF(File_Name) THEN sWriteLn(ScrStr) ELSE sWrite(ScrStr);
      END;
    END;
  END;
  CLOSE(File_Name);
  NoKill := FALSE;
  IF (MaxMode) AND (MouseOn) THEN ShowMouse;
END;
{}
PROCEDURE nstText(S : STRING ; LF : BOOLEAN);
VAR
  Len  : BYTE;
  Loop : BYTE;
  Bool : BOOLEAN;
BEGIN
  Len  := LENGTH(S);
  Bool := FALSE;
  FOR Loop := 1 TO Len DO BEGIN
    IF S[Loop] IN ['.',':',''] THEN Set_Color(8,0) ELSE
    IF Bool THEN Set_Color(11,0) ELSE Set_Color(3,0);
    IF S[Loop] = ' : ' THEN Bool := TRUE;
    sWrite(S[Loop]);
  END;
  IF LF THEN sWriteln('');
END;
{}
PROCEDURE ChatSelect;
BEGIN
END;
{}
PROCEDURE DVWrite(X,Y : WORD; Attr : BYTE; S : STRING);
BEGIN
END;
{}
PROCEDURE AlertTones;
VAR
  Loop : BYTE;
BEGIN
  FOR Loop := 1 TO 5 DO BEGIN
    WRITE(^G);
    DELAY(200);
  END
END;
{}
VAR
  U : WORD;
BEGIN
  GETDIR(0,HomeDir);
  DetectOS;
  Tdk_Vars.OS   := Gui_Util.OS;
  ResPath       := HomeDir + '\RESOURCE\';
  SesPath       := HomeDir + '\SESSION\';
  DownPath1     := HomeDir + '\DOWNS\';
  DownPath2     := DownPath1;
  ScrStr        := '';
  BackDropImage := '';
  C.ScreenColor := 33;
  ShowBanner    := FALSE;
  MaxID         := '2.03';
  Graphics      := MAX;
  MouseOn       := TRUE;
  UseSB         := TRUE;
  WITH SB DO BEGIN    {Be absolutely sure these settings match your  }
    IRQ     := '2';   {SoundBlaster settings or you will lock up the }
    DMA     := '1';   {computer tight as a drum as soon as you play  }
    Address := '220'; {any sound files....You have been warned....   }
  END;
  GETTIME(StartTime.Hour,StartTime.Min,StartTime.Sec,U);
  GETDATE(StartTime.Year,StartTime.Month,StartTime.Day,U);
  AddtoExitChain(ShutDownDoor);
  WITH CTL DO BEGIN
    Month        := StartTime.Month;
    Day          := StartTime.Day;
    Year         := StartTime.Year;
    SFirst       := 'The';
    SLast        := 'SysOp';
    SysSec       := 500;
    BBSname      := 'The BBS';
    SerialNumber := '';
    HomePath     := '';
    UseFossil    := FALSE;
    PortSpeed    := 38400;
    UseDigi      := FALSE;
    WordSize     := 8;
    Parity       := 'N';
    StopBits     := 1;
    InBuffer     := 4096;
    OutBuffer    := 4096;
    NSP          := FALSE;
    Port         := 0;
    IRQ          := 4;
    HexAddr      := '03F8';
  END;
  WITH CS DO BEGIN
    Hfg         := 15;
    Hbg         := 3;
    Wbg         := 1;
    Wh          := 9;
    Wl          := 0;
    Sfg         := 8;
    Sbg         := 0;
    Ffg         := 15;
    Fbg         := 1;
    Bfg         := 14;
    TxFG        := 3;
    TxBG        := 0;
    CPBfg       := 9;
    CPBbg       := 0;
    CPKfg       := 14;
    CPKbg       := 0;
    CPTfg       := 13;
    CPTbg       := 0;
  END;
  WITH DoorSys DO BEGIN
    UserName        := 'Joe User';
    Alias           := UserName;
    UserCity        := 'AnyTown, AnyState';
    PassWord        := 'PASSWORD';
    Phone           := '123-456-7890';
    WorkPhone       := Phone;
    BBSname         := 'The BBS';
    SysopName       := 'The SysOp';
    Access          := 500;
    UserNumber      := 0;
    Event           := 1400;
    ComPort         := 0;
    Baudrate        := 0;
    WhichIO         := InternalIO;
    IOinstalled     := FALSE;
    InBufSize       := 4096;
    OutBufSize      := 4096;
    IRQ             := 4;
    WordSize        := 8;
    Parity          := 'N';
    StopBits        := 1;
    Node            := 1;
    LocalInputON    := TRUE;
    UpdateStatusBar := TRUE;
    StatusBarY      := 25;
    LocalMaxY       := 25;
    MinutesLeft     := 1440;
    SecondsLeft     := MinutesLeft * LONGINT(60);
    IdleCount       := 0;
    UpdateSecs      := TRUE;
    UpdateIdle      := TRUE;
    LocalKey        := TRUE;
    OnLine          := TRUE;
  END;
  CurColor      := TextAttr;
  UFirst        := 'Joe';
  ULast         := 'User';
  BackSpaceChar := ' ';
  ErrLevel      := 0;
  LogPath       := FixPath(HomeDir);
  LogFile       := '';
  MiscFile      := '';
  DropFilePath  := '';
  s_ReadKey     := '';
  ProgramName   := 'No Program Name';
  ProgramDesc   := 'No Program Description';
  Copyright     := 'Copyright 1995-Current  Larry L. Athey  BBS Utiliteez Software';
  ClockOn;
END.
