/*********************************************************************
 ** CLOSECOM.CMD
 ** Created: 3.18.97; revised 4.3.97
 ** Author: DAVID ECKMAN
 ** Description:  Closes COM port if not in use, so other apps can use
 **    it.  For use with DOS/Win apps that capture the port and don't
 **    release it.
 *********************************************************************/

SIGNAL ON Halt

CALL SysCLS
com = ''
wait = ''

PARSE UPPER ARG com wait
IF com = '' THEN DO
  SAY
  SAY 'CLOSECOM requires the COM port number:'
  SIGNAL Help
END /* do */
com = STRIP( com, T, ':')
IF LEFT( com, 3) = 'COM' THEN com = RIGHT( com, LENGTH( com)-3)
IF DATATYPE( com) <> 'NUM' THEN DO
  SAY
  SAY 'An invalid value was used for the COM port number (see example):'
  SIGNAL Help
END /* do */
IF wait = '' THEN wait = 120
IF DATATYPE( wait) <> 'NUM' THEN DO
  SAY
  SAY 'An invalid value was used for the wait period (see example):'
  SIGNAL Help
END /* do */

DO FOREVER
  'SU' com 'DCD > NUL'
  IF rc = 0 THEN DO
    'SU' com 'close'
  END /* do */
  ELSE DO
    SAY
    SAY 'The port is in use; did not try to close it.'
  END /* do */
  SAY 'Time:' TIME('N')
  CALL SysSleep wait
END /* do forever */


Halt:
  SAY 'Ctrl+Break pressed. Exiting...'
  EXIT

Help:
  SAY
  SAY '   USAGE: CLOSECOM <#_of_COM_port> [<seconds>]'
  SAY '   Option: Add the number of <seconds> the program is to wait between calls'
  SAY '           to check whether the COM port is being used.  The default is 120.'
  SAY
  SAY '   Examples: CLOSECOM 2 or CLOSECOM COM1 60'
  SAY
  SAY 'To terminate CLOSECOM, hit Ctrl+Break or Ctrl+C.'
  SAY
  SAY 'Use of this program is conditioned on agreement to the terms stated in '
  SAY 'CLOSECOM.DOC, which is included in CLOSECOM.ZIP with this program.'
  EXIT

