
{-----------------------------------------------------------------------}
{									}
{	XMS Interface Unit for Borland Pascal 7.0, Version 1.1		}
{	Developed by Tanescu A. Horatiu					}
{	April 1997							}
{									}
{-----------------------------------------------------------------------}
{	Test program							}
{-----------------------------------------------------------------------}

program XMSDemo;

uses XMS;

var
  Handle : Word;  { handle to the eXtended memory block to be allocated	}
  Size   : Word;  { size of the block to allocate			}
  S      : string;{ what to write in eXtended memory			}
  SLen   : Byte;  { length of S						}

begin

  if (XMSInstalled = False) then	{ XMS initialization error	}
  begin
    WriteLn('Can''t use XMS: No XMS Driver Installed!');
    Halt(1)
  end;

  { print some statistics						}
  WriteLn;
  WriteLn('Free extended memory:               ', XMFreeSpace : 5, 'K');
  WriteLn('Largest free extended memory block: ', XMContig    : 5, 'K');
  WriteLn;

  Size   := 1;			{ we will allocate 1 K-byte		}
  Str(Size, S);

  Handle := XMAlloc(Size);	{ allocate an eXtended memory block	}
  if Handle = 0 then		{ allocation error			}
  begin
    { write an error message and exit					}
    PrintXMSError('Can''t allocate ' + S + 'K');
    Halt(1)
  end
  else WriteLn('Allocated ' + S + 'K');

  WriteLn;
  WriteLn('The following text is about to be written in eXtended memory:');
  S := 'Hello, world'; SLen := Length(S);
  WriteLn(S);

  { copy string into extended memory block				}
  CopyCMemToXMem(Handle, 0, Addr(S), SLen);

  S := '';

  { retreive string from extended memory block				}
  CopyXMemToCMem(Addr(S), Handle, 0, SLen);

  WriteLn('The following text was read back from eXtended memory:');
  WriteLn(S);

  XMFree(Handle);		{ free block				}

  { print some statistics						}
  WriteLn;
  WriteLn('Free extended memory:               ', XMFreeSpace : 5, 'K');
  WriteLn('Largest free extended memory block: ', XMContig    : 5, 'K')
end.