#include <stdio.h>
#include <vlib.h>

#include "setup.h"



UBYTE diff_lvl = 2;
UBYTE ltgrey, medgrey, dkgrey, black, white, yellow, purple;
Button *diffbutton[4], *hit_button;
Button *sliderbutton[2];

void main(void)
{
WORD mousespr, loop;

    desired_screen_height = 400;
    InitVLib(INIT_MOST);

    // Load background picture
    LoadPCX("..\\pcx\\beholder.pcx", double_buffer, colormap);
    SetPalette(colormap);

    // Find some nice colors
    ltgrey  = FindColor(colormap, 0x00909080);
    medgrey = FindColor(colormap, 0x00706060);
    dkgrey  = FindColor(colormap, 0x00505050);
    black   = FindColor(colormap, 0x00404040);
    white   = FindColor(colormap, 0x00909080);
    yellow  = FindColor(colormap, 0x00d0d000);
    purple  = FindColor(colormap, 0x00000068);

    // Create a sprite out of the built in mouse pointer data
    mousespr = AddSprite(mouseptr.width, mouseptr.height, mouseptrdata, 0);
    RemapSprite(mousespr, defaultcolormap, colormap);

    // Draw the interface stuff on the screen
    DrawScreen();

    // Add the difficulty level buttons to the screen
    while(difflevel.id <= NUMLEVELS) {
        diffbutton[difflevel.id - 1] = AddButton(&difflevel);
        difflevel.y += 10;
        difflevel.id += 1;
    }

    // Redraw levels so one is selected
    DrawDifficultyButtons();

    // Add the sliders
    sliderbutton[0] = AddButton(&soundslider);
    sliderbutton[1] = AddButton(&musicslider);
    DrawSliderButtons();

    // Add boolean buttons
    AddButton(&saveconfig);
    AddButton(&quitbutton);

    DoubleBuffer();

    while(1) {

        hit_button = CheckButtons();

        if(hit_button) {

            if(hit_button->id <= NUMLEVELS) {
                diff_lvl = hit_button->id - 1;
                DrawDifficultyButtons();
            }

            if(hit_button->id <= 0x0010)
                UpdateVolumes();

            if(hit_button->id <= 0x0011)
                UpdateVolumes();

//          if(hit_button->id == 0x0100)
//                  SaveConfigData();

            if(hit_button->id == 0x0101)
                break;
        }

        UpdateMouse(mousespr);
    }

    RemoveButton(0x0101);
    RemoveButton(0x0100);
    RemoveButton(0x0011);
    RemoveButton(0x0010);
    for(loop = 1; loop <= NUMLEVELS; loop++)
        RemoveButton(loop);

    FreeVLib();
}


void DrawScreen(void)
{
//    ScreenFill(medgrey);

    // Draw a long, short box up top for a titlebar
    Draw3DBoxFilled(4, 1, 635, 14, ltgrey, dkgrey, purple, SHAPE_OVAL);

    // Print the title with shadow (first)
    Text(11, 5, TITLETEXT, black);
    Text(10, 4, TITLETEXT, yellow);


    // Now do a box to put the difficulty options in
    Draw3DBox(4, 20, 216, 92, white, black, SHAPE_SMOOTH);

    Text(13, 29, BOXTITLE, black);
    Text(12, 28, BOXTITLE, white);

    // Now draw the options in
    Text(30, 44, OPTION1, white);
    Text(30, 54, OPTION2, white);
    Text(30, 64, OPTION3, white);
    Text(30, 74, OPTION4, white);

    // Draw a box for sound options (inset box)
    Draw3DBox(220, 20, 636, 92, black, white, SHAPE_SMOOTH);

    // Volume title and option text
    Text(227, 29, HEADING1, black);
    Text(226, 28, HEADING1, white);
    Text(226, 46, OPTION5, white);
    Text(226, 66, OPTION6, white);
}



void DrawDifficultyButtons(void)
{
ULONG loop;

    // First draw all difficulty buttons in normal state
    for(loop = 0; loop < NUMLEVELS; loop++) {
        diffbutton[loop]->flags &= ~BUTTON_FLAG_DOWN;
        DrawButton(diffbutton[loop], BUTTON_STATE_NORMAL);
    }

    diffbutton[diff_lvl]->flags |= BUTTON_FLAG_DOWN;
    DrawButton(diffbutton[diff_lvl], BUTTON_STATE_NORMAL);
}



void DrawSliderButtons(void)
{
    UpdateVolumes();

    SetSliderOffset(sliderbutton[0]);
    DrawButton(sliderbutton[0], BUTTON_STATE_NORMAL);
    SetSliderOffset(sliderbutton[1]);
    DrawButton(sliderbutton[1], BUTTON_STATE_NORMAL);
}



void UpdateVolumes(void)
{
static UBYTE volume;
static UBYTE text[4];

    DrawFilledBox(270, 46, 292, 74, 0);

    // Print sound volume
    volume = sliderbutton[0]->slider->currentry;
    sprintf(text, "%d", volume);
    Text(270, 46, text, white);

    // Print music volume
    volume = sliderbutton[1]->slider->currentry;
    sprintf(text, "%d", volume);
    Text(270, 66, text, white);
}