unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Winsock;

const
     ReadMyMsg =  WM_USER + 100; {Assign message number for ReadMyMsg}

type
  TForm1 = class(TForm)
    ExitButton     : TButton;
    StopReceiving  : TButton;
    Edit1          : TEdit;
    StartReceiving : TButton;
    DisplayServerIP: TButton;
    Memo1          : TMemo;
    label1         : TLabel;
    Label2         : TLabel;
    procedure StopReceivingClick(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
    procedure StartReceivingClick(Sender: TObject);
    procedure DisplayServerIPClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
    procedure Sreader(var Msg : TMessage); message ReadMyMsg; {Handler for FD_Read message}
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  s   :  TSocket;
  wsaDATA : tWSAData;
  mywindow  :   hWnd;
  verreq          :  wordrec;
   ii             :   integer;
   addr, bddr     :   TsockAddrin;
   nbytes         :   integer;
   recvbuf        : array[0..200] of char;
   s1             : string;
   nn             : integer;
   flag           : integer;



implementation

{$R *.DFM}

 
procedure TForm1.StopReceivingClick(Sender: TObject);  {Stop receiving}
begin

     if flag = 0 then
        begin
        MessageDlg('Not curently in receive mode', mtInformation, [mbOK], 0);
        exit
     end;

closesocket(s);
WSAcleanup;
flag := 0;
end;

procedure TForm1.ExitButtonClick(Sender: TObject);   {exit}
var
   st     :   string;

begin
if flag = 1 then
begin
closesocket(s);
WSACleanup
end;
st := 'Thank you for trying the Receiver test program' + chr(13) + chr(10);
st := st + chr(13) + chr(10) + 'Harry M. Pierson, Ph.D.' + chr(13) + chr(10);
st := st +  'DREJ Consulting' + chr(13) + chr(10);
st := st + '914-428-8070';
messagedlg(st , mtInformation, [mbOK], 0);
release;
application.terminate;
end;


procedure TForm1.StartReceivingClick(Sender: TObject);
begin
     with verreq do
          begin
               hi := 1;
               lo := 1;
          end;
     if flag = 1 then
        begin
        MessageDlg('You are already in receive mode', mtInformation, [mbOK], 0);
        exit
     end;

     nn := WSAStartUP(Word(verreq), wsaDATA);
     s := socket(AF_INET, SOCK_DGRAM, 0);
     addr.sin_family := AF_INET;
     addr.sin_port := htons(2222);
     addr.sin_addr.s_addr := htonl(INADDR_ANY);

     ii := bind(s, addr, sizeof(addr));     {binds socket s to port 2222 on this machine address}

     bddr.sin_family := AF_INET;
     bddr.sin_port := htons(2221);
     bddr.sin_addr.s_addr := htonl(INADDR_ANY);   {this IP address structure will be used}
                                                  {in the recvfrom statement to get IP of server}

           {Bottom line - We will be listening on port 2222 on this machine for}
           {a UDP broadcast from any machine broadcasting on port 2221}

     nn := sizeof(bddr);
     mywindow := form1.handle;
     flag := 1;
     ii := WSAAsyncSelect(s, mywindow, ReadMyMsg, FD_READ);
     {posts a ReadMyMsg message on FD_READ event, which is handled by Sreader}
end;


procedure Tform1.Sreader(var Msg : TMessage);

var
  st  :   string;

begin

recvbuf[0] := #0;
case loword(msg.lParam)  of
     FD_READ :   begin
      nn := sizeof(bddr);
      nbytes := recvfrom(s, recvbuf, 200, 0, bddr, nn);

      if recvbuf[0] <> 'x' then        {x is a semaphore to denote a message}
                                       {rather than just updating the clock}

     begin
     if edit1.text <> strpas(recvbuf) then edit1.text := strpas(recvbuf);
                                       {update time display if time changed}
     recvbuf[0] := #0
     end
     else                              {Display message from server}
     begin
     memo1.clear;
     st := strpas(recvbuf);
     st := copy(st,2,length(st)-1);    {take out x}
     memo1.lines[0] := st;
     end;
   end;
end;
end;

procedure TForm1.DisplayServerIPClick(Sender: TObject);
var
   ServerIP  :  string;

begin
     ServerIP := StrPas(inet_ntoa(bddr.sin_addr));
     MessageDlg('address = ' + ServerIP, mtInformation, [mbOK], 0);
end;


procedure TForm1.FormActivate(Sender: TObject);
begin
flag := 0;
memo1.clear;
end;

end.
