/*
 * Copyright (c) 1996-1997, InetSoft Technology Corp, All Rights Reserved.
 *
 * The software and information contained herein are copyrighted and 
 * proprietary to InetSoft Technology Corp. This software is furnished 
 * pursuant to a written license agreement and may be used, copied, 
 * transmitted, and stored only in accordance with the terms of such 
 * license and with the inclusion of the above copyright notice. Please 
 * refer to the file "COPYRIGHT" for further copyright and licensing 
 * information. This software and information or any other copies 
 * thereof may not be provided or otherwise made available to any 
 * other person. 
 */
package tea.set.sample;

import java.applet.*;
import java.awt.*;
import tea.set.*;
import java.net.*;

/**
 * This is a demo applet to show using tea.set.TickerTape to build an
 * information announcement board.
 *
 * @see TickerTape
 * @version 1.3, 01/31/97
 * @author InetSoft Technology Corp
 */
public class Ticker extends Applet {
   public void init() {
      setLayout(new BorderLayout());
      
      ticker1 = new TickerTape(mess, 1);
      ticker1.setForeground(Color.green);
      ticker1.setBackground(Color.black);
      add("North", ticker1);
      
      try {
	 URL url = new URL(getDocumentBase(), "Ticker.txt");
	 
	 ticker2 = new TickerTape(url, 5, TickerTape.LINE_SCROLL);
	 ticker2.setWidth(20);
	 add("Center", ticker2);
      }
      catch(Exception e) {
	 e.printStackTrace();
      }
   }
   
   public void start() {
      ticker1.start();
      ticker2.start();
   }
   
   public void stop() {
      ticker1.stop();
      ticker2.stop();
   }
   
   String mess = "INTC 96 1/2  IDTI 12 3/8  MSFT 122 1/8  IFMX  45 1/4  " +
   "ORCL 41 3/4  NOVL 10 3/8  T 56  ALSC 10 1/2  SIII 12 1/8  MU 40 1/8";
   TickerTape ticker1;
   TickerTape ticker2;
}
