/*
 * Copyright (c) 1996-1997, InetSoft Technology Corp, All Rights Reserved.
 *
 * The software and information contained herein are copyrighted and 
 * proprietary to InetSoft Technology Corp. This software is furnished 
 * pursuant to a written license agreement and may be used, copied, 
 * transmitted, and stored only in accordance with the terms of such 
 * license and with the inclusion of the above copyright notice. Please 
 * refer to the file "COPYRIGHT" for further copyright and licensing 
 * information. This software and information or any other copies 
 * thereof may not be provided or otherwise made available to any 
 * other person. 
 */
package tea.set.sample;

import tea.set.*;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;

/**
 * This is a demo applet to show using tea.set.Slider.
 *
 * @see Slider
 * @version 1.3, 01/31/97
 * @author InetSoft Technology Corp
 */
public class SliderDemo extends Applet {
   public void init() {
      setLayout(new GridLayout(4, 1));
      
      sld1 = new Slider();
      lb1 = new Label("0", Label.CENTER);
      sld1.addAdjustmentListener(new AdjustmentListener() {
	 public void adjustmentValueChanged(AdjustmentEvent e) {
	    lb1.setText(Integer.toString(sld1.getValue()));
	 }
      });
      
      add(lb1);
      add(sld1);
      
      sld2 = new Slider(0, 50, Adjustable.HORIZONTAL);
      sld2.setStyle(Slider.SCALE_BAR);
      lb2 = new Label("0", Label.CENTER);
      sld2.addAdjustmentListener(new AdjustmentListener() {
	 public void adjustmentValueChanged(AdjustmentEvent e) {
	    lb2.setText(Integer.toString(sld2.getValue()));
	 }
      });
      
      add(lb2);
      add(sld2);
   }
   
   private Slider sld1, sld2;
   private Label lb1, lb2;
}
