/*
 * Copyright (c) 1996-1997, InetSoft Technology Corp, All Rights Reserved.
 *
 * The software and information contained herein are copyrighted and 
 * proprietary to InetSoft Technology Corp. This software is furnished 
 * pursuant to a written license agreement and may be used, copied, 
 * transmitted, and stored only in accordance with the terms of such 
 * license and with the inclusion of the above copyright notice. Please 
 * refer to the file "COPYRIGHT" for further copyright and licensing 
 * information. This software and information or any other copies 
 * thereof may not be provided or otherwise made available to any 
 * other person. 
 */
package tea.set.sample;

import tea.set.*;
import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import java.net.*;
import java.util.*;

/**
 * This is a demostration applet, which extends MultiListA applet
 * to provide support for attaching URL to list items.
 *
 * @see MultiList
 * @see MultiListA
 * @version 1.3, 01/31/97
 * @author InetSoft Technology Corp
 */
public class MListURL extends MultiListA {
   public void init() {
      super.init();
      String str;

      // fetch the URL parameters
      for(int i = 0; (str = getParameter("ROW"+i)) != null; i++) {
	 if((str = getParameter("URL"+i)) == null) {
	    urls.addElement(null);
	 }
	 else {
	    try {
	       urls.addElement(new URL(getDocumentBase(), str));
	    }
	    catch(Exception e) {
	       e.printStackTrace();
	    }
	 }
      }
      
      MultiList list = (MultiList) getWidget();
      list.addActionListener(new MListAction());
      list.addMouseListener(new MListMouse());
      list.addMouseMotionListener(new MListMouseMotion());
   }
   
   // display URL at double mouse click inside an item
   class MListAction implements ActionListener {
      public void actionPerformed(ActionEvent e) {
	 MultiList list = (MultiList) e.getSource();
	 int r = list.getSelectedRow();
	 
	 if(r >= 0 && urls.elementAt(r) != null) {
	    getAppletContext().showDocument((URL) urls.elementAt(r));
	 }
      }
   }

   // display urs string associated with a row if the mouse pointer is
   // inside the row
   class MListMouse extends MouseAdapter {
      // clear applet message on mouse exit
      public void mouseExited(MouseEvent e) {
	 showStatus("");
      }
   }
      
   class MListMouseMotion extends MouseMotionAdapter {
      public void mouseMoved(MouseEvent e) {
	 MultiList list = (MultiList) e.getSource();
	 int row = list.locateRow(e.getX(), e.getY());
	 
	 if(row >= 0 && urls.elementAt(row) != null) {
	    showStatus(urls.elementAt(row).toString());
	 }
	 else {
	    showStatus("");
	 }
      }
      
   }
   
   private Vector urls = new Vector();
}
