/*
 * Copyright (c) 1996-1997, InetSoft Technology Corp, All Rights Reserved.
 *
 * The software and information contained herein are copyrighted and 
 * proprietary to InetSoft Technology Corp. This software is furnished 
 * pursuant to a written license agreement and may be used, copied, 
 * transmitted, and stored only in accordance with the terms of such 
 * license and with the inclusion of the above copyright notice. Please 
 * refer to the file "COPYRIGHT" for further copyright and licensing 
 * information. This software and information or any other copies 
 * thereof may not be provided or otherwise made available to any 
 * other person. 
 */
package tea.set.sample;

import tea.set.*;
import java.awt.*;
import java.net.*;
import java.applet.*;

/**
 * This is a demo applet to show using tea.set.Form to build an input
 * form interface.
 *
 * @see Form
 * @see TextGrid
 * @see Grid
 * @version 1.3, 01/31/97
 * @author InetSoft Technology Corp
 */
public class InputForm extends Applet {
   public void init() {
      setLayout(new BorderLayout());
      
      form = new Form();
      add("Center", new Effect3D(form, Effect3D.RAISED_BORDER));
      
      String[] fields = {"Last Name", "First Name", "Age", "Sex", "Education",
			 "Experience", "Level"};
      int[] fwidth = {15, 15, 3, 3, 15, 6, 15};
      form.setStyle(Form.TEXT_FIELD);
      form.setLayoutPolicy(Form.ROW_MAJOR);
      form.setRowColCount(2);
      form.setField(fields);
      form.setColumns(fwidth);
      form.setObject(3, "<SPIN>Male,Female");
      form.setObject(4, "<COMBO>Bachelor,Master,Doctor");
      form.setObject(6, "<CHOICE>MTS,DMTS,Superviser,DH");
   }
   
   private Form form;
}
