/*
 * Copyright (c) 1996-1997, InetSoft Technology Corp, All Rights Reserved.
 *
 * The software and information contained herein are copyrighted and 
 * proprietary to InetSoft Technology Corp. This software is furnished 
 * pursuant to a written license agreement and may be used, copied, 
 * transmitted, and stored only in accordance with the terms of such 
 * license and with the inclusion of the above copyright notice. Please 
 * refer to the file "COPYRIGHT" for further copyright and licensing 
 * information. This software and information or any other copies 
 * thereof may not be provided or otherwise made available to any 
 * other person. 
 */
package tea.set.sample;

import java.applet.*;
import java.awt.*;
import java.io.*;
import java.net.*;
import tea.set.*;

/**
 * This is a demo applet to show using tea.set.TextGrid to build a 
 * multi column list with data imported from a delimited file.
 *
 * @see Grid
 * @see TextGrid
 * @version 1.3, 01/31/97
 * @author InetSoft Technology Corp
 */
public class GridList extends Applet {
   public void init() {
      setLayout(new BorderLayout());
      try {
	 URL url = new URL(getDocumentBase(), "GridList.txt");
	 InputStream input = url.openStream();
	 
	 // create a TextGrid by importing data from a delimited 
	 // text file
	 grid = new TextGrid(input, "|");
	 grid.setEditable(false);

	 // set the column headers
	 grid.setColHeader(Tool.tokenize("Widget,Description,Category",","));
	 
	 // make the grid row and column selectable without 
	 // creating selectors (headers)
	 grid.setRowSelectable(true);
	 grid.setColSelectable(true);
	 
	 // add two pixel between rows
	 grid.setGap(Grid.ALL_CELL, Grid.ALL_CELL, new Insets(1, 0, 1, 0));
	 
	 // clear body ruling lines and set one ruling lines between
	 // header and body
	 grid.setRuling(Grid.NONE);
	 grid.setRuling(Grid.HEADER, Grid.ALL_CELL, Grid.HORIZONTAL);
	 
	 // set each alternate row to have different color
	 Color c = getBackground();
	 c = new Color(c.getRed()-25, c.getGreen()-25, c.getBlue()-25);
	 
	 for(int i = 1; i < grid.getRowCount(); i += 2) {
	    grid.setColor(i, Grid.ALL_CELL, c);
	 }
	 
	 // add a border using Effect3D and add scrolling support
	 // using Scroller
	 add("Center", 
	     new Effect3D(new Scroller(grid), Effect3D.RAISED_BORDER));
      }
      catch(Exception e) {
	 e.printStackTrace();
      }
   }

   private TextGrid grid;
}
