/*
 * Copyright (c) 1996-1997, InetSoft Technology Corp, All Rights Reserved.
 *
 * The software and information contained herein are copyrighted and 
 * proprietary to InetSoft Technology Corp. This software is furnished 
 * pursuant to a written license agreement and may be used, copied, 
 * transmitted, and stored only in accordance with the terms of such 
 * license and with the inclusion of the above copyright notice. Please 
 * refer to the file "COPYRIGHT" for further copyright and licensing 
 * information. This software and information or any other copies 
 * thereof may not be provided or otherwise made available to any 
 * other person. 
 */
package tea.set.sample;

import tea.set.*;
import java.awt.*;
import java.net.*;
import java.applet.*;

/**
 * This is a demo applet to show using tea.set.Grid to build a form
 * like interface.
 *
 * @see Grid
 * @see TextGrid
 * @version 1.3, 01/31/97
 * @author InetSoft Technology Corp
 */
public class GridForm extends Applet {
   public void init() {
      setLayout(new BorderLayout());
      
      grid = new TextGrid(5, 4);
      add("Center", new Effect3D(grid, Effect3D.RAISED_BORDER));
      
      grid.setRuling(Grid.NONE);
      grid.setEditable(false);
      grid.setGap(Grid.ALL_CELL, Grid.ALL_CELL, new Insets(2,2,2,2));

      try {
	 Image img = getImage(new URL(getDocumentBase(),"images/Duke/T1.gif"));
	 grid.setCell(0, 1, new ImageCanvas(img), 2, 1);
	 grid.setAlignment(0, 1, Grid.H_CENTER);
      } 
      catch(Exception e) {
	 e.printStackTrace();
      }
      
      grid.setObject(2, 0, "First Name:");
      grid.setObject(2, 1, "Duke");
      grid.setEditable(2, 1, true);
      
      grid.setObject(3, 0, "Last Name:");
      grid.setObject(3, 1, "Gosling?");
      grid.setEditable(3, 1, true);
      
      grid.setObject(4, 0, "Sex:");
      grid.setObject(4, 1, "<CHOICE>Unkown,Male,Female");
      
      grid.setObject(0, 2, "Habit:");
      grid.setObject(0, 3, "Likes to tumble\nWave at people a lot");
      grid.setSpanning(0, 3, 2, 1);
      grid.setEditable(0, 3, true);
      
      grid.setObject(2, 2, "Resume:");
      grid.setObject(2, 3, "Hired by Sun as the\nspokesman for Java\n"+
		     "liked by most people\nbecause of "+
		     "his\nfriendliness.");
      grid.setSpanning(2, 3, 3, 1);
      grid.setEditable(2, 3, true);
      
      grid.setForeground(Grid.ALL_CELL, 1, Color.white);
      grid.setBackground(Grid.ALL_CELL, 1, Color.gray);
      grid.setForeground(Grid.ALL_CELL, 3, Color.white);
      grid.setBackground(Grid.ALL_CELL, 3, Color.gray);
   }
   
   private TextGrid grid;
}
