/*
 * Copyright (c) 1996-1997, InetSoft Technology Corp, All Rights Reserved.
 *
 * The software and information contained herein are copyrighted and 
 * proprietary to InetSoft Technology Corp. This software is furnished 
 * pursuant to a written license agreement and may be used, copied, 
 * transmitted, and stored only in accordance with the terms of such 
 * license and with the inclusion of the above copyright notice. Please 
 * refer to the file "COPYRIGHT" for further copyright and licensing 
 * information. This software and information or any other copies 
 * thereof may not be provided or otherwise made available to any 
 * other person. 
 */
package tea.set.sample;

import java.applet.*;
import java.awt.*;
import tea.set.*;

/**
 * This is a demo applet to show using tea.set.TextGrid.
 *
 * @see Grid
 * @see TextGrid
 * @version 1.3, 01/31/97
 * @author InetSoft Technology Corp
 */
public class GridDuo extends Applet {
   public void init() {
      setLayout(new BorderLayout(0, 15));
      
      add("North", form);
      add("South", new Effect3D(list, Effect3D.RAISED_BORDER));
      
      form.setRuling(Grid.NONE);
      form.setAlignment(Grid.ALL_CELL, 0, Grid.H_RIGHT);
      form.setForeground(Grid.ALL_CELL, 1, Color.white);
      form.setBackground(Grid.ALL_CELL, 1, Color.gray);
      form.setAlignment(Grid.ALL_CELL, 1, Grid.H_LEFT);
      form.setAlignment(Grid.ALL_CELL, 2, Grid.H_RIGHT);
      form.setForeground(Grid.ALL_CELL, 3, Color.white);
      form.setBackground(Grid.ALL_CELL, 3, Color.gray);
      form.setGap(Grid.ALL_CELL, Grid.ALL_CELL, new Insets(1,2,1,2));
      for(int i = 0; i < layout.length; i++) {
	 form.setRow(i, Tool.tokenize(layout[i], ";"));
      }

      list.setEditable(true);
      list.setCharSize(Grid.ALL_CELL, 0, new Dimension(15, 1));
      list.setCharSize(Grid.ALL_CELL, 1, new Dimension(20, 1));
      list.setCharSize(Grid.ALL_CELL, 2, new Dimension(40, 1));
      list.setColHeader(Tool.tokenize("Skill;Level;Description", ";"));
   }
   
   private String[] layout = {"First Name;<EDIT:1,15>;Last Name;<EDIT:1,15>",
			      "SS#;<MASK>[999]-[99]-[9999]",
			      " ;<BUTTON>Retrieve;<BUTTON>Save;"
   };
   private TextGrid form = new TextGrid(3, 4);
   private TextGrid list = new TextGrid(5, 3);
}
