/*
 * Copyright (c) 1996-1997, InetSoft Technology Corp, All Rights Reserved.
 *
 * The software and information contained herein are copyrighted and 
 * proprietary to InetSoft Technology Corp. This software is furnished 
 * pursuant to a written license agreement and may be used, copied, 
 * transmitted, and stored only in accordance with the terms of such 
 * license and with the inclusion of the above copyright notice. Please 
 * refer to the file "COPYRIGHT" for further copyright and licensing 
 * information. This software and information or any other copies 
 * thereof may not be provided or otherwise made available to any 
 * other person. 
 */
package tea.set.sample;

import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import tea.set.*;

/**
 * This is a demo applet to show using tea.set.Graph to build an
 * interactive graph.
 *
 * @see Graph
 * @version 1.3, 01/31/97
 * @author InetSoft Technology Corp
 */
public class GraphDemo extends Applet {
   public void init() {
      setLayout(new BorderLayout());
      
      // create the dataset for the x axis
      yx = new DataSet(false);
      yx.setData(yearX);
      mx = new DataSet(false);
      mx.setData(monthX);
      
      add("North", title = new Label("Revenue (Million)"));
      
      // create the initial graph for yearly data
      graph = new Graph(yx.getData(), (new DataSet(yearY)).getData());
      add("Center", graph);
      
      graph.addItemListener(new GraphItemListener());
      graph.addMouseListener(new GraphMouseListener());
      
      // display 3D bar chart
      graph.setStyle(Graph.BAR3D);
   }
   
   // drill down if clicked in a yearly chart, or return to yearly chart
   // if currently displaying monthly data and mouse click is outside
   // of chart area
   class GraphItemListener implements ItemListener {
      public void itemStateChanged(ItemEvent e) {
	 // drill down if in yearly chart and user clicked inside a bar
	 if(dsIdx == 0) {
	    Point p = (Point) e.getItem();
	    graph.setValues(mx.getData(), (new DataSet(y[p.x])).getData());
	    dsIdx = p.x + 1;
	 }
      }
   }
   
   class GraphMouseListener extends MouseAdapter {
      public void mousePressed(MouseEvent e) {
	 // return to yearly chart if clicked outside of any bar
	 if(dsIdx != 0) {
	    dsIdx = 0;
	    graph.setValues(yx.getData(), (new DataSet(yearY)).getData());
	 }
      }
   }
   
   private Label title;
   private Graph graph;
   
   private int dsIdx = 0;
   private DataSet yx;
   private DataSet mx;
   
   private String[] yearX = {"1994", "1995", "1996"};
   private int yearY[] = {210, 244, 305};
   private String[] monthX = {"Jan", "Feb", "Mar", "Apr", "May", "Jun", 
			      "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
   private int y[][] = { {12, 18, 15, 16, 8, 22, 25, 46, 8, 15, 11, 14},
			 {19, 18, 17, 16, 20, 22, 25, 36, 17, 25, 16, 13},
			 {29, 21, 19, 23, 15, 18, 33, 40, 52, 21, 11, 23} };
}
