/*
 * Copyright (c) 1996-1997, InetSoft Technology Corp, All Rights Reserved.
 *
 * The software and information contained herein are copyrighted and 
 * proprietary to InetSoft Technology Corp. This software is furnished 
 * pursuant to a written license agreement and may be used, copied, 
 * transmitted, and stored only in accordance with the terms of such 
 * license and with the inclusion of the above copyright notice. Please 
 * refer to the file "COPYRIGHT" for further copyright and licensing 
 * information. This software and information or any other copies 
 * thereof may not be provided or otherwise made available to any 
 * other person. 
 */
package tea.set.sample;

import tea.set.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;

/**
 * DynaTree is an example program to demostrate Forest widget. It 
 * takes a path, and generates a directory tree. However the directory
 * tree is not read in at the beginning. When an user clicks on a
 * directory node, the nodes under the directory is read in and
 * populated to the tree.
 *
 * @see Forest
 * @version 1.3, 01/31/97
 * @author InetSoft Technology Corp
 */
public class DynaTree extends Frame {
   /**
    * Create a directory tree from the root path.
    */
   public DynaTree(String rootPath) {
      setLayout(new BorderLayout());
    
      // create Forest and set appropriate options
      forest = new Forest(Forest.LINE);
      // use the same separator as the file system for separating nodes
      forest.setSeparator(File.separatorChar);
      // open/close folder only if mouse click is in icon
      forest.setIconOnly(true);
      
      // never close root folder
      forest.forceOpen(rootPath, true);

      // populate the first level nodes
      populateTree(rootPath);
      
      // put forest inside a Scroller to ensure all parts of forest
      // can be seen
      add(scroller = new Scroller(forest, true, 200, 200), "Center");
      Button b = new Button("Cancel");
      add(b, "North");
      
      b.addActionListener(new ActionListener() {
	 public void actionPerformed(ActionEvent e) {
	    dispose();
	    System.exit(0);
	 }
      });
      
      forest.addItemListener(new ItemListener() {
	 public void itemStateChanged(ItemEvent e) {
	    Node node = (Node) e.getItem();
	    String path = node.getPath();
	    File root = new File(path);
	    if(root.isDirectory() && node.isLeaf()) {
	       populateTree(path);
	       scroller.notifyUpdate();
	    }
	 }
      });
   }

   // populate the tree nodes from the directory information.
   public void populateTree(String rootPath) {
      // add current dir/file to the tree
      forest.findNode(rootPath, true);
      
      try {
	 File root = new File(rootPath);
	 
	 if(root.isDirectory()) {
	    String[] files = root.list();
	    
	    if(files != null) {
	       for(int i = 0; i < files.length; i++) {
		  String path = rootPath + File.separator + files[i];
		  forest.findNode(path, true);
	       }
	    }
	 }
      }
      catch(Exception e) {
	 e.printStackTrace();
      }
      
      forest.doLayout();
      forest.repaint();
   }
   
   /**
    * Pass a directory path as command line parameter. On Win32 platform,
    * beware that the backslash needs to be escaped.
    * For a directory tree from current directory, type:
    * java tea.set.sample.FileTree .
    */
   public static void main(String argv[]) {
      DynaTree tree = new DynaTree(argv[0]);
      tree.pack();
      tree.forest.setImage(tree.forest.getImage(Forest.FOLDER_CLOSE),
			   Forest.FOLDER_LEAF);
      tree.show();
   }
   
   private Forest forest;
   private Scroller scroller;
}
