/*
 * Copyright (c) 1996-1997, InetSoft Technology Corp, All Rights Reserved.
 *
 * The software and information contained herein are copyrighted and 
 * proprietary to InetSoft Technology Corp. This software is furnished 
 * pursuant to a written license agreement and may be used, copied, 
 * transmitted, and stored only in accordance with the terms of such 
 * license and with the inclusion of the above copyright notice. Please 
 * refer to the file "COPYRIGHT" for further copyright and licensing 
 * information. This software and information or any other copies 
 * thereof may not be provided or otherwise made available to any 
 * other person. 
 */
package tea.set.sample;

import java.applet.*;
import java.awt.*;
import tea.set.*;

/**
 * This is a demo applet to show using tea.set.CardFile to build a 
 * simple calendar.
 *
 * @see CardFile
 * @see Folder
 * @see YearCal
 * @see MCalendar
 * @version 1.3, 01/31/97
 * @author InetSoft Technology Corp
 */
public class CardCal extends Applet {
   public void init() {
      setLayout(new BorderLayout());
      
      folder = new CardFile(CardFile.LEFT_RIGHT);
      folder.setBorder(new Insets(4, 4, 4, 4));
      
      YearCal cal; 
      
      cal = new YearCal(96, 0, 96, 2, 3, 1);
      folder.add("1st Quarter", new Effect3D(cal, Effect3D.RAISED_BORDER));
      
      cal = new YearCal(96, 3, 96, 5, 3, 1);
      folder.add("2nd Quarter", new Effect3D(cal, Effect3D.RAISED_BORDER));
      
      cal = new YearCal(96, 6, 96, 8, 3, 1);
      folder.add("3rd Quarter", new Effect3D(cal, Effect3D.RAISED_BORDER));
      
      cal = new YearCal(96, 9, 96, 11, 3, 1);
      folder.add("4th Quarter", new Effect3D(cal, Effect3D.RAISED_BORDER));
      
      folder.flush();
      add("Center", folder);
   }
   
   private CardFile folder;
}
