unit DemoForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, SoundStr, SoundAcm, Gauges, ExtCtrls, SKFormat;

type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    Panel1: TPanel;
    Gauge1: TGauge;
    Label1: TLabel;
    Label2: TLabel;
    fn1: TEdit;
    fn2: TEdit;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    sa: TSoundKitACM;
    ws1: TWinSoundKitWaveStream;
    ws2: TWinSoundKitWaveStream;
    fl1: TLabel;
    fl2: TLabel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure saConvertDone(Sender: TObject; Progress, Total: Longint);
    procedure saConvertEnd(Sender: TObject; Progress, Total: Longint);
    procedure saConvertStart(Sender: TObject; Progress, Total: Longint);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
{$R *.DFM}

{..............................................................................}

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
  if OpenDialog1.Execute then begin
    fn1.Text        := OpenDialog1.Filename;
    ws1.Filename    := OpenDialog1.Filename;
    fl1.Caption     := ws1.Format.Description;
  end;
end;

{..............................................................................}

procedure TForm1.SpeedButton2Click(Sender: TObject);
begin
  if SaveDialog1.Execute then begin
    fn2.Text := SaveDialog1.Filename;
    ws2.Filename := SaveDialog1.Filename;
  end;
end;

{..............................................................................}

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
  SelectCompressionFormat( Handle, 'Select a Format', sa.FormatOut, wfUnKnown, ncNone,ssZero, 0 );
  fl2.Caption     := sa.FormatOut.Description;
end;

{..............................................................................}

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
  sa.FormatIn.Assign( ws1.Format );
  ws2.Format.Assign( sa.FormatOut );
  if ws1.OpenRead and ws2.OpenWrite and sa.Open then sa.StreamConvert( ws1.WStream, ws2.WStream )
  else ShowMessage( 'Cannot Open' );
  ws1.Close; ws2.Close; sa.Close;
end;

{..............................................................................}

procedure TForm1.saConvertDone(Sender: TObject; Progress, Total: Longint);
begin
  Gauge1.Progress := Progress;
  Application.ProcessMessages;
end;

{..............................................................................}

procedure TForm1.saConvertEnd(Sender: TObject; Progress, Total: Longint);
begin
  Gauge1.Progress := 0;
end;

{..............................................................................}

procedure TForm1.saConvertStart(Sender: TObject; Progress, Total: Longint);
begin
  Gauge1.Progress := 0;
  Gauge1.MaxValue := Total;
end;

{..............................................................................}

end.
