/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "useron.h"
#include "stdmac.h"
#include "pbnames.h"
#include "file.h"
#include "pblsdk.h"
#include "proboard.h"

#ifndef PB_SDK
	#include <assert.h>
	#include <stdio.h>
	#include <string.h>
#else
	#include "pblibc.h"
#endif

zUserOnline::zUserOnline(Boolean userdoes, Boolean doing):
	m_UserDoes(userdoes),
	m_Doing(doing)
{
}

void
zUserOnline::Create(short nNode, char *text)
{
	assert(text != 0);
	if( m_UserDoes ) CreateUserDoes(nNode, text);
	if( m_Doing ) CreateDoing(nNode, text);
}

void
zUserOnline::Remove(short nNode)
{
	if( m_UserDoes ) RemoveUserDoes(nNode);
	if( m_Doing ) RemoveDoing(nNode);
}

const short zUserOnline::m_MaxDoingLen = 30;     // 31 with EOS

void
zUserOnline::CreateDoing(short nNode, char *text)
{
	char  path[MAXPATH], buf[m_MaxDoingLen + 1];
	FILE *fp;

	strcpy(path, pb_getpath(fnDOING, PBDIR_SYS));
	if( !file_exist(path) ) InitDoing();
	fp = fopen(path, "r+b");
	if( fp ){
		strncpy(buf, text, m_MaxDoingLen);
		buf[m_MaxDoingLen] = EOS;
		fseek(fp, long(nNode-1) * (m_MaxDoingLen+1), SEEK_SET);
		fwrite(buf, sizeof(buf), 1, fp);
		fclose(fp);
	}
}

void
zUserOnline::RemoveDoing(short nNode)
{
	char path[MAXPATH];

	strcpy(path, pb_getpath(fnDOING, PBDIR_SYS));
	if( !file_exist(path) ) InitDoing();
	else{
		FILE *fp = fopen(path, "r+b");
		if( fp ){
			char buf[m_MaxDoingLen + 1];

			memset(buf, 0, sizeof(buf));
			fseek(fp, long(nNode-1) * (m_MaxDoingLen+1), SEEK_SET);
			fwrite(buf, sizeof(buf), 1, fp);
			fclose(fp);
		}
	}
}

char*
zUserOnline::GetDoing(short nNode, char *dest)
{
	FILE *fp;

	strcpy(dest, "");
	fp = pb_fopen(fnDOING, "rb", PBDIR_SYS);
	if( fp ){
		fseek(fp, long(nNode-1) * (m_MaxDoingLen+1), SEEK_SET);
		fread(dest, m_MaxDoingLen + 1, 1, fp);
		fclose(fp);
	}
	return dest;
}

void
zUserOnline::InitDoing()
{
	char    dbuf[m_MaxDoingLen + 1];
	FILE   *fp;

	memset(dbuf, 0, sizeof(dbuf));
	fp = pb_fopen(fnDOING, "wb", PBDIR_SYS);
	if( fp ){
		for( int i = 0; i < Config->numnodes; ++i )
			fwrite(dbuf, sizeof(dbuf), 1, fp);
		fclose(fp);
	}
}

const short zUserOnline::m_MaxUserDoesLen = 21;  // 22 with EOS

void
zUserOnline::CreateUserDoes(short nNode, char *text)
{
	char  path[MAXPATH];
	char  buf[m_MaxUserDoesLen + 1];
	FILE *fp;

	sprintf(path, "%s.%d", pb_getpath(fnUSERDOES, PBDIR_SYS), nNode);
	fp = fopen(path, "wb");
	if( fp ){
		strncpy(buf, text, m_MaxUserDoesLen);
		buf[m_MaxUserDoesLen] = EOS;
		fwrite(buf, m_MaxUserDoesLen + 1, 1, fp);
		fclose(fp);
	}
}

void
zUserOnline::RemoveUserDoes(short nNode)
{
	char path[MAXPATH];

	sprintf(path, "%s.%d", pb_getpath(fnUSERDOES, PBDIR_SYS), nNode);
	file_remove(path);
}

char*
zUserOnline::GetUserDoes(short nNode, char *dest)
{
	char  path[MAXPATH];
	FILE *fp;

	sprintf(path, "%s.%d", pb_getpath(fnUSERDOES, PBDIR_SYS), nNode);
	strcpy(dest, "");
	fp = fopen(path, "rb");
	if( fp ){
		fread(dest, m_MaxUserDoesLen + 1, 1, fp);
		fclose(fp);
	}
	return dest;
}
