/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "_termint.h"
#include "_termctl.h"
#include "utils.h"

#ifndef PB_SDK
	#include <ctype.h>
	#include <string.h>
#else
	#include "pblibc.h"
#endif

/*
 * p c b o a r d   a n d   w i l d c a t !   c o l o r   c l a s s
 * 
 * this implements the @-code PCBoard and Wildcat! color specifications. it
 * also supports the @CLS@ code for both of them (none of the other macros)
*/
Boolean
pcboard_interp::init( uchar aSOS )
{
	Boolean retval = False;

	if( '@' == aSOS )
	{
		term_interp::init(aSOS);
		retval = True;
	}

	return retval;
}

void
pcboard_interp::handle( uchar aChar )
{
	if( 3 == m_buff->getCount() )
	{ // we might be at the end of sequence
		if( 'X' == m_buff->bp()[1] ){ // PCBoard @Xbf code
			if( isxdigit(m_buff->bp()[2]) && isxdigit(aChar) )
			{
				m_ctrl->set_color(hexColor(m_buff->bp()[2], aChar));
				m_eos = True;
			}
			else
			{
				m_buff->put(aChar);
				m_fail = True;
			}
			return;
		}
		else if( '@' == aChar )
		{ // Wildcat! end of sequence @bf@ code
			if( isxdigit(m_buff->bp()[1]) && isxdigit(m_buff->bp()[2]) )
			{
				m_ctrl->set_color(hexColor(m_buff->bp()[1], m_buff->bp()[2]));
				m_eos = True;
			}
			else
			{
				m_buff->put(aChar);
				m_fail = True;
			}
			return;
		}
	}
	// check for the @CLS@ code
	if( 3 < m_buff->getCount() )
	{
		if( '@' == aChar && 0 == memicmp(&m_buff->bp()[1], "CLS", 3) )
		{
			m_ctrl->clr_scr();
			m_eos = True;
		}
		else
		{
			m_buff->put(aChar);
			m_fail = True;
		}
		return;
	}
	// not end of sequence yet, store character
	m_buff->put(aChar);
}

