/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "_termint.h"
#include "_termctl.h"
#include "parsevar.h"
#include "stdmac.h"

#ifndef PB_SDK
	#include <string.h>
#else
	#include "pblibc.h"
#endif

/*
 * m a c r o   p a r s e r   c l a s s
 * 
 * the implementation of the @<>@ macro parser class (with new gizmonics)
*/
Boolean
macro_interp::init(uchar aSOS)
{
	Boolean retval = False;

	if( '@' == aSOS )
	{
		term_interp::init(aSOS);
		m_prevChar = 0;
		retval     = True;
	}

	return retval;
}

void
macro_interp::handle(uchar aChar)
{
	char result[255];

	m_buff->put(aChar);

	// early check, is this out macro format
	// this also catches control symbols down
	// the line (less than space -> invalid!)
	if( ' ' > aChar || 2 == m_buff->getCount() )
	{
		if( '<' != aChar ) m_fail = True;
		return;  // already stuffed in buffer
	}

	// are we nearing the end here
	if( '>' == aChar )
	{
		m_prevChar = aChar;
		return;
	}

	// is this the actual end of the sequence
	if( '>' == m_prevChar )
	{
		if( '@' != aChar )
		{ // duh! not a macro
			m_fail = True;
			return;
		}
		// here we have a perfectly formed macro (somewhat)
		m_buff->bp()[m_buff->getCount() - 2] = EOS; // stringize
		switch( parse_macro(result, &m_buff->bp()[2]) )
		{
			case 0:
				strcat(m_buff->bp(), ">@");
				m_fail = True;
				break;
			case 1: m_ctrl->put(result, strlen(result)); // fall-through
			case 2: m_eos = True; // this means it was an action
		}
	}
}
