/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "_termctl.h"
#include "comdef.h"

#ifndef PB_SDK
	#include <conio.h>
	#include "compiler.h"
#else
	#include "pblibc.h"
	#include "pblsdk.h"
#endif

int term_ctrl::m_x     =  1;
int term_ctrl::m_y     =  1;
int term_ctrl::m_fg    =  7;
int term_ctrl::m_bg    =  0;
int term_ctrl::m_rows  = 25;
int term_ctrl::m_cols  = 80;
int term_ctrl::m_lines =  0;

int
term_ctrl::put(const char *aString, size_t len)
{
	int retval;

	m_lines = 0;

	while( len-- )
	{
		char aChar = *aString++;

		retval = putch(aChar);
		switch( aChar )
		{
			case '\r': m_x = 1; break;
			case '\n': m_y++; break;
			case '\b': if( 1 < m_x ) m_x--; break;
			case '\a': break; // bell (don't ring)
			default  : m_x++;
		}
		if( m_x > m_cols )
		{ // line wrap
			m_x = 1;
			m_y += 1;
			m_lines++;
		}
		if( m_y > m_rows )
		{  // screen wrap
			m_y--;
			m_lines++;
		}
	}

	return retval;
}

void
term_ctrl::cursor_up(int rows)
{
	m_y = max(1, m_y - rows);
}

void
term_ctrl::cursor_down(int rows)
{
	m_y = min(m_rows, m_y + rows);
}

void
term_ctrl::cursor_left(int cols)
{
	m_x = max(1, m_x - cols);
}

void
term_ctrl::cursor_right(int cols)
{
	m_x = min(m_cols, m_x + cols);
}

void
term_ctrl::cursor_xy(int x, int y)
{
	m_x = max(1, min(m_cols, x));
	m_y = max(1, min(m_rows, y));
}

////////////////////////////////////////////////////////////////////////////
console_ctrl::console_ctrl()
{
	term_ctrl::cursor_xy(wherex(), wherey());
}

void
console_ctrl::clr_scr()
{
	term_ctrl::clr_scr();
	clrscr();
}

void
console_ctrl::clr_eol()
{
	term_ctrl::clr_eol();
	clreol();
}

void
console_ctrl::set_fg(int fg)
{
	term_ctrl::set_fg(fg);
	textattr((get_bg() << 4) | (fg & 0x0f));
}

void
console_ctrl::set_bg(int bg)
{
	term_ctrl::set_bg(bg);
	textattr((bg << 4) | get_fg());
}

void
console_ctrl::set_color(int attrib)
{
	term_ctrl::set_color(attrib);
	textattr(attrib);
}

void
console_ctrl::cursor_xy(int x, int y)
{
	term_ctrl::cursor_xy(x,y);
	gotoxy(x,y);
}

void
console_ctrl::cursor_up(int rows)
{
	term_ctrl::cursor_up(rows);
	gotoxy(get_x(), get_y());
}

void
console_ctrl::cursor_down(int rows)
{
	term_ctrl::cursor_down(rows);
	gotoxy(get_x(), get_y());
}

void
console_ctrl::cursor_left(int cols)
{
	term_ctrl::cursor_left(cols);
	gotoxy(get_x(), get_y());
}

void
console_ctrl::cursor_right(int cols)
{
	term_ctrl::cursor_right(cols);
	gotoxy(get_x(), get_y());
}
