/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "comdef.h"
#include "str.h"

/*
 * adds two numbers represented as strings and returns resulting string.
 * the result must be free()'ed by the caller as it is dynamically allocated
 * this only works with strings without any signs or extraneous characters
*/
char*
stradd( char *dest, const char *s1, const char *s2 )
{
	size_t      len1 = strlen(s1);
	size_t      len2 = strlen(s2);
	size_t      diff = len1 - len2, i;
	const char *p;
	char       *buf;
	 int        inc;

	if( len2 > len1 )
	{
		swap(len1, len2);
		swap(s1, s2);
		diff = -diff;
	}
	if( NULL == (buf = (char *)malloc( len1 + 2 )) )
	{
		dest[0] = EOS;
		return NULL;
	}
	memset( dest, EOS, len1 + 2 );
	memset( buf, '0', diff );
	strcpy( &buf[diff], s2 );

	for( i = inc = 0, len1--, p = &s1[len1]; p >= s1; --len1, --p, ++i )
	{
		int val = inc + (*p + buf[len1] - 96);
		if( 9 < val )
		{
			inc = 1;
			val %= 10;
		}
		else inc = 0;
		dest[i] = val + '0';
	}
	if( inc ) dest[i] = '1';

	free( buf );
	return strrev(dest);
}

