/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "proboard.h"
#include "pbnames.h"
#include "pbstruct.h"
#include "stdmac.h"

#ifndef PB_SDK
	#include <string.h>
#endif

// load the hotkeys from a menu (pass the name of the menu)
char*
pb_menukeys(const char *menuName)
{
	static char buf[255]; // overwritten with each call
	short       i = 0;
	MENU_ITEM   item;

	sprintf(buf, "%s%s", menuName, fnMENUEXT);
	FILE *fp = pb_fopen(buf, "rb", PBDIR_MENU);
	if( fp ){
		buf[0] = EOS;
		fseek(fp, (long)sizeof(MENU_HEADER), SEEK_SET);
		fread(&item, sizeof(item), 1, fp);
		while( !feof(fp) ){
			if( !strchr(buf, item.hotkey) ) buf[i++] = item.hotkey;
			fread(&item, sizeof(item), 1, fp);
		}
		fclose(fp);
		buf[i] = EOS;
		return buf;
	}
	return 0;
}
