/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "proboard.h"
#include "pblsdk.h"
#include "file.h"

/*
 * this displays a file from a directory. extensions are matched.
 *
 * 'fname'     - root name of the file (path and extension ignored)
 * 'keys'      - hotkeys that will stop processing (use NULL for none)
 * 'dir'       - directory where the file(s) are located ('\\' - terminated)
 * 'pTerminal' - pointer to terminal object to use for display
*/
int
pb_showfile(char *fname, char *keys, char *dir, zTerminal * const pTerminal)
{
	char    root[MAXPATH];
	char    path[MAXPATH];
	Boolean bHasAvtPlus = Boolean(CurUser->uFlags & UFLAG_AVTPLUS);
	Boolean bHasAvatar  = Boolean(CurUser->uFlags & UFLAG_AVATAR);
	Boolean bHasAnsi    = Boolean(CurUser->uFlags & UFLAG_ANSI);

	sprintf(root, "%s%s", dir, file_name(fname));

	if( bHasAvtPlus )
	{
		file_chext(path, root, ".AVP");
		if( file_exist(path) ) return pb_showfile(path, keys, pTerminal);
	}

	if( bHasAvtPlus || bHasAvatar )
	{
		file_chext(path, root, ".AVT");
		if( file_exist(path) ) return pb_showfile(path, keys, pTerminal);
	}

	if( bHasAvtPlus || bHasAvatar || bHasAnsi )
	{
		file_chext(path, root, ".ANS");
		if( file_exist(path) ) return pb_showfile(path, keys, pTerminal);
	}

	file_chext(path, root, ".ASC");

	return pb_showfile(path, keys, pTerminal);
}
