/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "proboard.h"
#include "pblang.h"
#include "pblsdk.h"

#ifndef PB_SDK
	#include <ctype.h>
	#include <assert.h>
#else
	#include "pblibc.h"
#endif

/*
 * return 1 on yes, 2 on continuous, 0 on stop
*/
int
pb_askmore(zTerminal * const pTerminal)
{
	zProLang   lang(pTerminal);
	char       hkeys[5];
	char       key;

	if( !lang.Error() ) lang.Exec(4);
	strcpy(hkeys, lang.GetItemKeys(4));

#ifdef PB_SDK
	const char *p = lang.GetItemText(4);
	if( p && strstr(p, "@p") ){
		printf("more (%c/%c/%c)? ", hkeys[0], hkeys[1], hkeys[2]);
	}
#endif

	strupr(strcat(hkeys, "\r"));
	key = toupper(WaitKeys(hkeys));

	if( hkeys[1] == key ) return 0;
	if( hkeys[2] == key ) return 2;

	return 1;
}
