/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "utils.h"
#include "stdmac.h"

#ifndef PB_SDK
	#include <dos.h>
#else
	#include "pblibc.h"
#endif

/*
 *  a getch() work-alike for use with extended keyboards
 *  returns extended key code as follows (mapped in KEYCODES.H):
*/
static ushort
DoKeyGet( Boolean retrieve )
{
	ushort     key;
	union REGS regs;

	if( !retrieve )
	{
		if( !key_ishit() ) return 0;
		else
		{
			regs.h.ah = 0x11;
			int86(0x16, &regs, &regs);
			key = regs.x.ax;
		}
	}
	else
	{
		regs.h.ah = 0x10;
		int86(0x16, &regs, &regs);
		key = regs.x.ax;
	}

	return key;
}

ushort
key_read()
{
	return DoKeyGet( True );
}

ushort
key_peek()
{
	return DoKeyGet( False );
}
