/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "file.h"
#include "compiler.h"
#include "stdmac.h"

#ifndef PB_SDK
	#include <string.h>
	#include <io.h>
	#ifdef _MSC_VER
		#include <sys/types.h>
	#endif
	#include <dir.h>
	#include <sys/stat.h>
#endif

/*
 * a simple rescursive directory tree parser, deletes all files on its way
*/
int
DoRmtree( const char *curPath )
{
	zDosFile ffblk;
	char     path[MAXPATH], newPath[MAXPATH];
	int      done;

	strcat( strcpy(path, curPath), "\\*.*" );

	done = FindFirst(path, FA_ALL, &ffblk);
	while( !done )
	{
		if( ffblk.attrib & FA_DIREC )
		{
			if( '.' != *ffblk.name )
			{
				strcat( strcpy(newPath, curPath), "\\" );
				DoRmtree( strcat(newPath, ffblk.name) );
				if( -1 == rmdir(newPath) ) return -1;
			}
		}
		else
		{
			strcat( strcpy(newPath, curPath), "\\" );
			chmod( strcat(newPath, ffblk.name), S_IREAD | S_IWRITE );
			if( -1 == unlink(newPath) ) return -1;
		}
		done = FindNext(&ffblk);
	}

	/* can't remove current directory */
	if( 0 != strcmp(curPath, ".") )	return rmdir((char *)curPath);
	else return 0;
}

/*
 * this is the wrapper function, strips the trailing backslash (if any)
*/
int
file_rmdir( char *path )
{
	char *p;
	// remove any trailing backslashes, those will be appended later
	if( '\\' == *(p = &LAST_CHAR(path)) ) *p = EOS;
	return DoRmtree( path );
}
