/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#ifdef PB_SDK
	#error "This module compiles ONLY in non-SDK mode!"
#endif

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include "file.h"
#include "proboard.h"
#include "profile.h"
#include "utils.h"
#include "pbuser.h"
#include "pbnames.h"
#include "emulator.h"

/////////////////////////////////////////////////////////////////////////////
// without a larger stack... kaboom!
/////////////////////////////////////////////////////////////////////////////
#ifdef __TURBOC_
extern unsigned _stklen = 0x8000U;
#endif

/////////////////////////////////////////////////////////////////////////////
// PB-Lib emulator structures
/////////////////////////////////////////////////////////////////////////////
zTerminal                          *pblib_Terminal;
ansi_interp                        *pblib_AnsiHandler;
avatar_interp                      *pblib_AvatarHandler;
proboard_interp                    *pblib_ProboardHandler;
zTerminal       * const Terminal =  pblib_Terminal;

/////////////////////////////////////////////////////////////////////////////
// these are the SDK structures which should be globally available
/////////////////////////////////////////////////////////////////////////////
USER_REC       * const  CurUser = 0;
USER_REC       *       &pblib_CurUser = (USER_REC *)CurUser;
LIMIT    const * const  Limits = 0;
LIMIT          *       &pblib_Limits = (LIMIT *)Limits;
CONFIG   const * const  Config = 0;
CONFIG         *        &pblib_Config = (CONFIG *)Config;
char                    pblib_LoginDate[3];
char           * const  LoginDate = pblib_LoginDate;
char                    pblib_LoginTime[3];
char           * const  LoginTime = pblib_LoginTime;
char                    pblib_UserFirstName[30];
char     const * const  UserFirstName = pblib_UserFirstName;
char                    pblib_SysPath[80];
char     const * const  SysPath = pblib_SysPath;
char                    pblib_CurMenu[10] = "MAIN";
char     const * const  CurMenu = pblib_CurMenu;
char                    pblib_PrevUser[36] = "";
char     const * const  PrevUser = pblib_PrevUser;
char                    pblib_StartupPath[80];
char     const * const  StartupPath = pblib_StartupPath;
char                    pblib_PageReason[80] = "";
char           * const  PageReason = pblib_PageReason;
ushort                  pblib_PageCount = 0;
ushort         * const  PageCount = &pblib_PageCount;
short            const  NumLimits = 0;
short          * const  pblib_NumLimits = (short *)&NumLimits;
short            const  NumUsers = 1;
short          * const  pblib_NumUsers = (short *)&NumUsers;
BOOL             const  NetEntered = FALSE;
BOOL           * const  pblib_NetEntered = (BOOL *)&NetEntered;
BOOL             const  EchoEntered = FALSE;
BOOL           * const  pblib_EchoEntered = (BOOL *)&EchoEntered;
short            const  UserRecNr = 0;
short          * const  pblib_UserRecNr = (short *)&UserRecNr;
short            const  NodeNumber = 1;
short          * const  pblib_NodeNumber = (short *)&NodeNumber;
long             const  BaudRate = 0L;
long           * const  pblib_BaudRate = (long *)&BaudRate;
ushort           const  PBVersion = 0x020F;
ushort           const  Beta = 0x0300;

/////////////////////////////////////////////////////////////////////////////
// define the startup and exit functions
/////////////////////////////////////////////////////////////////////////////
//#pragma startup proboard_emulator_init 100
//#pragma exit    proboard_emulator_term 100

/////////////////////////////////////////////////////////////////////////////
// proboard emulator initialization and shutdown routines
/////////////////////////////////////////////////////////////////////////////
void
proboard_emulator_init()
{
	char     *env_ptr = getenv("PROBOARD");
	FILE     *file_ptr;
	zProfile  ini;

	/*
	 * allocate memory for variables
	*/
	pblib_Config          = new CONFIG;
	pblib_CurUser         = new USER_REC;
	pblib_Terminal        = new zTerminal;
	pblib_AvatarHandler   = new avatar_interp;
	pblib_AnsiHandler     = new ansi_interp;
	pblib_ProboardHandler = new proboard_interp;

	if(    !pblib_Config        || !pblib_CurUser
		|| !pblib_Terminal      || !pblib_AnsiHandler
		|| !pblib_AvatarHandler || !pblib_ProboardHandler )
	{
		fail("not enough memory to initialize global structures");
	}

	/*
	 * setup default terminal emulation (enable ansi, avatar and proboard)
	*/
	pblib_Terminal->RegisterHandler(pblib_AvatarHandler);
	pblib_Terminal->RegisterHandler(pblib_ProboardHandler);
	pblib_Terminal->RegisterHandler(pblib_AnsiHandler);

	/*
	 * get the system directory from environment
	*/
	if( !env_ptr ) fail("environment not set");
	strcpy(pblib_SysPath, env_ptr);
	file_appchr(pblib_SysPath, 0);

	/*
	 * get most of the other variables from the .INI file (or use defaults)
	*/
	if( 0 != (env_ptr = getenv("PBLIB")) ) ini.Assign(env_ptr, 0);
	else ini.Assign("pblib.ini", 0);
	ini.Open();
	ini.ReadShort(0, "UserRecNr", pblib_UserRecNr, 0);
	ini.ReadShort(0, "NodeNumber", pblib_NodeNumber, 1);
	ini.ReadShort(0, "PageCount", (short *)PageCount, 0);
	ini.ReadLong(0, "BaudRate", pblib_BaudRate, 0L);
	ini.ReadBool(0, "EchoEntered", (Boolean*)pblib_EchoEntered, False);
	ini.ReadBool(0, "NetEntered", (Boolean*)pblib_NetEntered, False);
	ini.ReadString(0, "StartupPath", pblib_StartupPath, pblib_SysPath);
	ini.ReadString(0, "CurMenu", pblib_CurMenu, "MAIN");
	ini.ReadString(0, "PageReason", pblib_PageReason, "");
	ini.ReadString(0, "PrevUser", pblib_PrevUser, "");
	ini.Close();
	/*
	 * load the main configuration record (note that we can only use
	 * the PBDIR_SYS enumeration before we load the CONFIG here!!!
	*/
	file_ptr = pb_fopen(fnCONFIG, "rb", PBDIR_SYS);
	if( !file_ptr ) fail("unable to load configuration");
	file_read(file_ptr, pblib_Config);
	fclose(file_ptr);

	/*
	 * load the limit definitions from the proboard configuration
	*/
	env_ptr = pb_getpath(fnLIMITS, PBDIR_SYS);
	*pblib_NumLimits = file_size(env_ptr) / sizeof(LIMIT);
	if( 0 < *pblib_NumLimits )
	{
		file_ptr = fopen(env_ptr, "rb");
		if( !file_ptr ) *pblib_NumLimits = 0;
		else
		{
			pblib_Limits = new LIMIT [*pblib_NumLimits];
			if( !pblib_Limits ) fail("ran out of hunk while limiting");
			fread(pblib_Limits, sizeof(LIMIT), *pblib_NumLimits, file_ptr);
			fclose(file_ptr);
		}
	}
	/*
	 * set up the login date and time information here (current time)
	*/
	time_t timer  = time(NULL);
	struct tm *tm = localtime(&timer);

	pblib_LoginDate[0] = tm->tm_mday;
	pblib_LoginDate[1] = tm->tm_mon + 1;
	pblib_LoginDate[2] = tm->tm_year;

	pblib_LoginTime[0] = tm->tm_hour;
	pblib_LoginTime[1] = tm->tm_min;
	pblib_LoginTime[2] = tm->tm_sec;

	/*
	 * load the record from the userbase. note that we can safely use
	 * this class once we have the CONFIG record loaded (for paths, etc.)
	*/
	zProUser userbase;
	*pblib_NumUsers = (short)userbase.GetTotal();
	if( !userbase.Load( (long)UserRecNr) ) fail("can't find user");
	else memcpy(pblib_CurUser, &userbase.m_rec, sizeof(USER_REC));

	/*
	 * setup the first name of the current user and name of previous user
	*/
	sscanf(pblib_CurUser->name, "%s", pblib_UserFirstName);
	if( EOS == pblib_PrevUser[0] ) strcpy(pblib_PrevUser, Config->sysopname);
}

void
proboard_emulator_term()
{
	if( pblib_Limits          ) delete[] pblib_Limits;
	if( pblib_AvatarHandler   ) delete   pblib_AvatarHandler;
	if( pblib_ProboardHandler ) delete   pblib_ProboardHandler;
	if( pblib_AnsiHandler     ) delete   pblib_AnsiHandler;
	if( pblib_Terminal        ) delete   pblib_Terminal;
	if( pblib_CurUser         ) delete   pblib_CurUser;
	if( pblib_Config          ) delete   pblib_Config;
}
