/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "edit.h"
#include "kbcodes.h"
#include "stdmac.h"

#ifndef PB_SDK
	#include <string.h>
	#include <stdlib.h>
	#include <ctype.h>
	#include <stdio.h>
#else
	#include "pblibc.h"
#endif

////////////////////////////////////////////////////////////////////////////
// Input a number derived class
////////////////////////////////////////////////////////////////////////////
zEditNumber::zEditNumber(const zRect &r, short aMaxLen, short aOptions):
	zEditLine(r, aMaxLen),
    options(aOptions)
{
	if( options & edit_options::blank ) strcpy(data, "0");
    if( options & edit_options::hex ) options |= edit_options::pos;
}

void
zEditNumber::setData(void *ptr)
{
	char buf[20];
	long nData = *(long *)ptr;

	if( options & edit_options::pos ) nData = labs(nData);
	if( options & edit_options::hex ) sprintf(buf, "0x%lX", nData);
	else sprintf(buf, "%ld", nData);
	zEditLine::setData(buf);
}

void
zEditNumber::getData(void *ptr)
{
	char buf[20];
    long nData;

    zEditLine::getData(buf);
    if( EOS == buf[0] && (options & edit_options::blank) ) strcpy(data, "0");
    if( 'X' == buf[1] ) nData = strtol(buf, NULL, 16);
    else nData = strtol(buf, NULL, 10);
    *(long *)ptr = nData;
}

void
zEditNumber::handle(ushort aKeyCode)
{
	char charCode = aKeyCode;

    if( ' ' <= aKeyCode && aKeyCode < 127 )
    {
    	switch( toupper(charCode) )
    	{
        	case '-': case '+':
				if( options & edit_options::pos ) aKeyCode = kbNoKey;
				else if( (0 != curPos) ||
					(insertMode && ('+' == data[0] || '-' == data[0])) )
                {
					aKeyCode = kbNoKey;
                }
                break;

            case 'X':
            	if( !(options & edit_options::hex) ||
					(1 != curPos) || '0' != data[0] )
                {
					aKeyCode = kbNoKey;
				}
                break;

            case 'A': case 'B': case 'C': case 'D': case 'E': case 'F':
				if( !(options & edit_options::hex) ) aKeyCode = kbNoKey;
                break;

            case '0': case '1': case '2': case '3': case '4':
			case '5': case '6': case '7': case '8': case '9':
                break;

            default: return;
		}
	}

    zEditLine::handle(aKeyCode);
}

