/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "edit.h"
#include "stdmac.h"
#include "kbcodes.h"

#ifndef PB_SDK
	#include <string.h>
#else
	#include "pblibc.h"
#endif

////////////////////////////////////////////////////////////////////////////
// Date input class (supports MM/DD/YY, DD/MM/YY formats), can also write
// a background to show the format that is expected. Does some validation
////////////////////////////////////////////////////////////////////////////
const char *zEditDate::euro = "DD/MM/YY";
const char *zEditDate::amer = "MM/DD/YY";
const char *zEditDate::none = "  /  /  ";

zEditDate::zEditDate(const zRect &bounds, short aOptions):
	zEditNumber(bounds, 8, edit_options::pos),
    options(aOptions)
{
	if( !(options & edit_options::european) &&
		!(options & edit_options::american) )
	{
		options |= edit_options::american;	// force format
	}

	if( options & edit_options::show )
	{
		if( options & edit_options::european ) strcpy(data, euro);
		else if( options & edit_options::american ) strcpy(data, amer);
	}
	else strcpy(data, none);
}

void
zEditDate::getData(void *rec)
{
	strcpy((char*)rec, data);
}

void
zEditDate::setData(void *rec)
{
	strncpy(data, (char*)rec, 8);
    data[8] = EOS;
    data[2] = data[5] = '/';
    selectAll();
}

void
zEditDate::handle(ushort aKeyCode)
{
	char charCode = aKeyCode;

    endSel = startSel = 0;
    insertMode = False;

    switch( aKeyCode )
    {
		case kbBkSp:
		    aKeyCode = kbLeft;
		    break;
		case kbDel :
		case kbCtlY:
		case kbCtlT:
			aKeyCode = kbNoKey;
		    break;
	}

    if( '0' <= charCode && '9' >= charCode )
    {
		if( 2 == curPos || 5 == curPos ) zEditNumber::handle(kbRight);
	}

    if( valid(aKeyCode) ) zEditNumber::handle(aKeyCode);

    if( 2 == curPos || 5 == curPos )
    {
		if( kbLeft == aKeyCode || kbBkSp == aKeyCode )
			 zEditNumber::handle(kbLeft);
        else
			 zEditNumber::handle(kbRight);
	}
}

// perform data validation
Boolean
zEditDate::valid(ushort aCode)
{
	// only check the digits, the zEditNumber will filter the rest
	if( '0' <= aCode && '9' >= aCode )
	{
    	switch( curPos )
    	{
        	case 0 :
            	if( options & edit_options::american )
            	{ // this is month
            monthCheck_1:
                	if( '1' < aCode ) return False;
                    else return True;
				}
                else
                { // european-style, this is a day number
            dayCheck_1:
                	if( '3' < aCode ) return False;
                    else return True;
				}

			case 1 :
				if( options & edit_options::american )
				{ // second digit of the month
            monthCheck_2:
                	if( data[curPos-1] == '1' && '2' < aCode ) return False;
                    else return True;
				}
                else
                { // second digit of the day
            dayCheck_2:
					if( '3' == data[curPos-1] && '1' < aCode ) return False;
                    else return True;
				}

            case 3 :
            	if( options & edit_options::american ) goto dayCheck_1;
                else goto monthCheck_1;
            case 4 :
            	if( options & edit_options::american ) goto dayCheck_2;
                else goto monthCheck_2;

            case 6 :	// fall-through, the year can be anything
            case 7 :
            default: return True;	// not an interesting position here
		}
	}
	return True;
}
