/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "edit.h"
#include "dlist.h"
#include "comdef.h"
#include "stdmac.h"
#include "kbcodes.h"
#include "utils.h"

#ifndef PB_SDK
	#include <string.h>
	#include <ctype.h>
	#include <conio.h>
#else
	#include "pblibc.h"
	#include "pblsdk.h"
#endif

////////////////////////////////////////////////////////////////////////////
// The line with the combo list of selections (only those accepted)
////////////////////////////////////////////////////////////////////////////
zEditCombo::zEditCombo(const zRect &bounds, short aOptions, zDoubleList *items):
	zEditLine(bounds, 0),
    options(aOptions),
    list(items),
	iter(new zListCursor(*list)),
    nCompare(0)
{
	if( list->size() )
	{
	    if( data ) delete[] data;
	    maxLen = 0;
	    do
	    {
			maxLen = max(maxLen, (short)strlen((char*)iter->get()));
		}while( iter++ );
	    data = new char [maxLen + 1];
	    *data = EOS;

	    iter->begin();
	    if( options & edit_options::init ) strcpy(data, (char *)iter->get());
    }
}

zEditCombo::~zEditCombo()
{
	if( options & edit_options::dispose ) delete list;
	if( iter ) delete iter;
}


void
zEditCombo::getData(void *ptr)
{
	strcpy((char*)ptr, data);
}

void
zEditCombo::setData(void *ptr)
{
	if( list->size() )
	{
		iter->begin();
	    do
	    {
	    	if( 0 == strcmp((char*)ptr, (char*)iter->get()) ) break;
		}while( iter++ );
	    strcpy(data, (char*)iter->get());
    }
}

void
zEditCombo::handle(ushort aKeyCode)
{
	char code = aKeyCode;

	if( !list->size() ) return;		// nothing in the list

	if( ' ' == code )
	{
		if( key_stat() & 3 )
		{ // Shit key depressed?
			if( !iter->prev() ) iter->end();
		}
		else
		{
			if( !iter->next() ) iter->begin();
		}
		strcpy(data, (char*)iter->get());
		nCompare = 0;
		selectAll();
	}
	else if( isalnum(code) || kbHome == aKeyCode || kbBkSp == aKeyCode)
	{
		incrementalSearch(aKeyCode);
	}

	draw();
	gotoxy(origin.x + nCompare - firstPos + 1, origin.y);
}

// implement the incremental search in either direction
void
zEditCombo::incrementalSearch(ushort aKeyCode)
{
	char         buf[256];
    Boolean      found = False;
	zListCursor  temp = *iter;

	if( kbBkSp == aKeyCode ) if( nCompare ) nCompare--;
	else if( kbHome == aKeyCode ) nCompare = 0;

	strncpy(buf, (char *)iter->get(), nCompare);
    buf[nCompare] = EOS;
	if( isalnum(aKeyCode) && nCompare < maxLen )
	{
		buf[nCompare++] = aKeyCode;
        buf[nCompare] = EOS;
	}
    if( nCompare )
    {
	    temp.begin();
	    do
	    {
	    	if( 0 == strnicmp((char*)temp.get(), buf, nCompare) )
	    	{
	        	strcpy(data, (char*)temp.get());
				*iter = temp;
	            found = True;
				nCompare = min(nCompare, (short)strlen(data));
	            selectAll();
	            endSel = 0;
	        	break;
			}
		}while( temp.next() );
	    if( !found ) nCompare--;
    }
}
