/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "utils.h"

/*
 * r e t r i e v e   t h e   d o s   v e r s i o n
 * 
 * this module implements the routine which retrieves the current dos version
*/
#ifndef PB_SDK
	#include <dos.h>
#else
	#include "pblibc.h"
#endif

/*
 * returns the true MS-DOS version number, major in lo-byte, minor in hi-byte
*/
int
_dos_version( void )
{
	union REGS regs;

	regs.x.ax = 0x3306;
	regs.x.bx = 0x0000;
	int86( 0x21, &regs, &regs );
	if( 0 != regs.x.bx ) return regs.x.bx;

	/*
	 * if the undocumented function is not supported, do the regular
	 * except this one can be fooled by SETVER
	*/
	regs.x.ax = 0x3000;
	int86( 0x21, &regs, &regs );
	if( 0 == regs.h.al ) return 0x0001;  /* version 1.0 didn't have it */
	else return regs.x.ax;
}
