/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "utils.h"

/*
 * d e t e c t   i f   f i l e   s h a r i n g   a v a i l a b l e
 * 
 * this module implements the file sharing availability status (dos/os2/win)
*/
#ifndef PB_SDK
	#include <dos.h>
#else
	#include "pblibc.h"
#endif

/*
 * is Share.Exe loaded (or file sharing available, as in Win95)
*/
int
_dos_share_loaded( void )
{
	union REGS r;

	r.x.ax = 0x1000;
	int86( 0x2f, &r, &r );
	if( 0xff == r.h.al ) return 1;
	else return 0;
}
