/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "pblibc.h"

char*
mktemp(char *temp)
{
	size_t  len = strlen(temp);
	char   *p;

	if( len < 6 )
		return 0;

	p = temp + len - 6;

	if( strcmp(p, "XXXXXX") )
		return 0;

	p[2] = '.';

	for( int a = 'A'; a <= 'Z'; ++a )
	{
		p[0] = a;
		for( int b = 'A'; b <= 'Z'; ++b )
		{
			p[1] = b;
			for( int c = 'A'; c <= 'Z'; ++c )
			{
				p[3] = c;
				for( int d = 'A'; d <= 'Z'; ++d )
				{
					p[4] = d;
					for( int e = 'A'; e <= 'Z'; ++e )
					{
						p[5] = e;

						if( -1 == access(temp, 0) )
						{
							return temp;
						}
					}
				}
			}
		}
	}

	return 0;
}
