/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "pblibc.h"

// same as the eof() in some compiler libraries - this one is for
// the SDK, Symantec, Zortech and DJGPP that don't have it ;-)
int
eof( int handle )
{
	long curpos = tell( handle );
	int  retval = -1;

	if( -1 != curpos ){
		lseek(handle, 0L, SEEK_END);
		if( curpos == tell(handle) ) retval = 1;
		else retval = 0;
		lseek(handle, curpos, SEEK_SET);
	}
	return retval;
}

