/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "pblibc.h"

static int
DoChmod(const char *path, int func, int attrib )
{
	struct SREGS s;
	union  REGS  r;

	r.h.ah = 0x43;
	r.h.al = func;
	r.x.cx = attrib;
	s.ds = FP_SEG(path);
	r.x.dx = FP_OFF(path);
	int86x(0x21, &r, &r, &s);
	if( r.x.cflag ) return -1;
	else return r.x.cx;
}

/*
 * chmod() version for the SDK
*/
	int
chmod( const char *path, int amode )
{
	int attr;

	attr = DoChmod(path, 0, 0);
	if( -1 == attr ) return -1;
	if( amode & S_IWRITE ) attr &= ~0x0001;
	return (-1 != DoChmod(path, 1, attr)) ? 0 : -1;
}
