/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#ifndef INCLUDED_PBLSDK_H
#define INCLUDED_PBLSDK_H
#include "stdmac.h"

#ifndef PB_SDK
	#include <string.h>
	#include <conio.h>
#else
	#include "pblibc.h"
#endif

/*
 * p r o b o a r d   s d k   i n t e r f a c e
 * 
 * this is a messy module. it implements the mapping of the standard SDK that
 * comes with proboard as well as the additional standard CRTL routines which
 * have been implemented by PB-Lib. it also serves as the header file for all
 * pexen that are to be compiled with the library (you also need PB_SDK.OBJ)
*/
#include "typedef.h"
#include "pbstruct.h"

/*
 
  USER_REC - structure for CurUser, also built by ReadUser(). The 'record'
  field is the record number in USERS.BBS 0-based. The password CRC is the
  32-bit CRC of the upper-case password string. The sex, dateFormat, and
  logLevel fields use SEX_???, DATE_???, and LOG_??? constants defined in
  PROBOARD.H (refer to the notes for the user record descriptions)
 
*/
#define UFLAG_DELETED    (0x00000001L) //........................user deleted
#define UFLAG_ANSI       (0x00000002L) //........................ansi mode on
#define UFLAG_PAUSE      (0x00000004L) //.......................pause mode on
#define UFLAG_CLEAR      (0x00000008L) //.................screenclear mode on
#define UFLAG_HOTKEYS    (0x00000010L) //............................hotkeys?
#define UFLAG_NOIBM      (0x00000020L) //............user has no ibm-graphics
#define UFLAG_FSED       (0x00000040L) //..............fullscreen editor used
#define UFLAG_NOKILL     (0x00000080L) //....................do not kill user
#define UFLAG_IGNORE     (0x00000100L) //.....................ignore dl-hours
#define UFLAG_ATTEN      (0x00000200L) //......................attention flag
#define UFLAG_NOTOPS     (0x00000400L) //................don't appear in tops
#define UFLAG_HIDDEN     (0x00000800L) //.....................hide from lists
#define UFLAG_QUIET      (0x00001000L) //.............................quiet??
#define UFLAG_AVATAR     (0x00002000L) //.........................avt/0 codes
#define UFLAG_AVTPLUS    (0x00004000L) //........................avt/0+ codes
#define UFLAG_GUEST      (0x00008000L) //.......................guest account
#define UFLAG_PAGEPRI    (0x00010000L) //.......................page priority
#define UFLAG_LOCALONLY  (0x00020000L) //....................local login only
#define UFLAG_MULTILOGIN (0x00040000L) //................allow multiple login
#define UFLAG_FREECHAT   (0x00080000L) //................freeze timer in chat
#define UFLAG_NORIP      (0x00100000L) //.........................disable rip

typedef struct{
	long     record;               //.......record number in users.bbs, (0..)
	char     name[36];             //...............................user name
	char     alias[36];            //............................alias/handle
	char     passWord[16];         //................................password
	ulong    passWordCRC;          //.........32-bit crc of the uppercase pwd
	ushort   level;                //..........................security level
	char     country[26];          //.................................country
	char     state[26];            //...................................state
	char     city[26];             //....................................city
	char     company[51];          //.................................company
	char     address1[51];         //..........................address line 1
	char     address2[51];         //..........................address line 2
	char     address3[51];         //..........................address line 3
	char     comment[81];          //.................................comment
	char     forwardTo[36];        //.........................forward mail to
	DateType birthDate;            //................................birthday
	char     voicePhone[16];       //...........................voice phone #
	char     dataPhone [16];       //............................data phone #
	char     faxPhone  [16];       //.............................fax phone #
	uchar    sex;                  //...............see the sex_??? constants
	uchar    dateFormat;           //......date format, see the date_? consts
	uchar    defaultProtocol;      //.................default protocol hotkey
	char     language[9];          //................................language
	ushort   screenWidth;          //............................screen width
	ushort   screenLength;         //..............................# of lines
	long     timeUsed;             //.........................time used today
	ulong    timesCalled;          //..........................# times called
	ulong    numDownloads;         //.............................# downloads
	ulong    kbDownloaded;         //............................k downloaded
	ulong    numUploads;           //.............................# downloads
	ulong    kbUploaded;           //............................k downloaded
	ulong    msgsPosted;           //.......................# messages posted
	DateType lastDate;             //........................date last called
	DateType lastTime;             //........................time last called
	DateType lastPwdChange;        //............date of last password change
	DateType lastNewFilesCheck;    //........date of last check for new files
	ulong    aFlags;               //..................access flags (A-Z,1-6)
	ulong    uFlags;               //.........flags, see the UFLAG_??? consts
	ushort   logLevel;             //.......................log level of user
	uchar    mailCheckBoards[125]; //.............msg areas to check for mail
	uchar    combinedBoards[125];  //.......areas to be used in combined mode
	ulong    totalTimeUsed;        //...............total time used (minutes)
	DateType expDate;              //.........................expiration date
	ushort   expLevel;             //.........fallback level after expiration
	ulong    expFlagsOn;           //....flags to be enabled after expiration
	ulong    expFlagsOff;          //...flags to be disabled after expiration
	DateType firstDate;            //.....................date of first login
	long     kbToday;              //......................k downloaded today
	long     credit;               //..........................netmail credit
	long     pending;              //..................netmail credit pending
	ushort   fileArea;             //.................last file area accessed
	ushort   msgArea;              //..................last msg area accessed
	short    tbTimeBalance;        //......time balance           (time bank)
	short    tbKbBalance;          //......kbyte balance          (time bank)
	short    tbTimeWithdrawn;      //......time withdrawn today   (time bank)
	short    tbKbWithdrawn;        //......kbytes withdrawn today (time bank)
	ushort   tbTimeDeposited;      //......time deposited today   (time bank)
	ushort   tbKbDeposited;		   //......kbytes deposited today (time bank)
	ushort   tbTimeLoaned;		   //......time loaned today      (time bank)
	ushort   tbKbLoaned;		   //......kbutes loaned today    (time bank)
	DateType tbLastUsed;           //......date last used         (time bank)
	uchar    checkMail;            //.................check for mail at logon
	uchar    checkNewFiles;        //............check for new files at logon
	ulong    highMsgRead;          //.........message id of the last one read
	ushort   qwkMaxMsgsPerArea;    //........qwk packer max messages per area
	ushort   qwkMaxMsgs;		   //......qwk packer max messages per packet
	uchar    qwkArchiver;		   //..............qwk packer archiver to use
	uchar    ripFont;			   //..................rip font (small/large)
	DateType tbTimePayback;		   //......time payback date      (time bank)
	DateType tbKbPayback;		   //......kbytes payback date    (time bank)
	ushort   fileGroup;			   //...............current file group number
	ushort   msgGroup;			   //............current message group number
	uchar    extra[390];
} USER_REC;

//................message structure used by the message manipulation routines
#define MSGATTR_PRIVATE     (0x00000001L)  //.................private message
#define MSGATTR_RECEIVED    (0x00000002L)  //................message received
#define MSGATTR_DELETED     (0x00000004L)  //..............message is deleted
#define MSGATTR_NETMAIL     (0x00000008L)  //.................netmail message
#define MSGATTR_UNSENT_ECHO (0x00000010L)  //.........unsent echomail message
#define MSGATTR_UNSENT_NET  (0x00000020L)  //..........unsent netmail message
#define MSGATTR_LOCAL       (0x00000040L)  //.........locally entered message
#define MSGATTR_KILL        (0x00000080L)  //..................kill when sent
#define MSGATTR_CRASH       (0x00000100L)  //........send with crash priority
#define MSGATTR_SENT        (0x00000200L)  //...........message has been sent
#define MSGATTR_FILE        (0x00000400L)  //.........message has file attach
#define MSGATTR_REQ         (0x00000800L)  //.......message is a file request
#define MSGATTR_AUDIT       (0x00001000L)  //.....message is an audit request
#define MSGATTR_RET         (0x00002000L)  //......has return receipt request

typedef struct{
	long     num;       //.....................................message number
	long     id;        //..................................unique message id
	char     from[36];  //......................................sender's name
	char     to  [36];  //....................................receiver's name
	char     subj[66];  //.......................................subject text
	ulong    attr;      //...........attribute, see the MSGATTR_??? constants
	DateType postDate;  //............................date message was posted
	TimeType postTime;  //............................time message was posted
	DateType recvDate;  //..........................date message was received
	TimeType recvTime;  //..........................time message was received
	long     next;      //..........number of the next message in reply chain
	long     prev;      //............number of previous message in the chain
	short    origZone;  //......................................sender's zone
	short    origNet;   //.......................................sender's net
	short    origNode;	//......................................sender's node
	short    origPoint;	//.....................................sender's point
	short    destZone;	//....................................receiver's zone
	short    destNet;	//.....................................receiver's net
	short    destNode;	//....................................receiver's node
	short    destPoint;	//...................................receiver's point
	short    cost;		//.....................message cost (netmail credits)
	short    area;		//...............number of message area message is in
	short    extra;
} MESSAGE;

#ifdef PB_SDK //.............................................the original SDK
/*
 * t h e   o r i g i n a l   p r o b o a r d   s d k
 * 
 * this is a part from the original header file PB_SDK.H which deals with
 * non-library SDK-specific routines and definitions. use for pexen only!
*/
#define PBSDK_VERSION 215

#ifdef __cplusplus
	extern "C" {
#endif

//...........................................long math substitution functions
long  l_mul(long val1,long val2);
long  l_div(long val1,long val2);
long  l_mod(long val1,long val2);
long  l_shl(long val,unsigned s);
long  l_shr(long val,unsigned s);
ulong ul_div(ulong val1,ulong val2);
ulong ul_mod(ulong val1,ulong val2);
ulong ul_shl(ulong val,ushort s);
ulong ul_shr(ulong val,ushort s);

char* form(char *, ...); //..........................from old C++ streams lib
//..................................................message related functions
void  MsgEd(void);
short PostMessage(const char *from,const char *to,const char *subject,short area,BOOL pvt);
short PostNetmail(const char *from,const char *to,const char *subject,short area,const FIDO_NODE *address,BOOL attach,BOOL crash,BOOL kill);
BOOL  ReadMsgArea(short area,MSGAREA *ma);
short NumMsgAreas(void);
long  GetLastRead(short areanum , long user_recno);
void  SetLastRead(short areanum , long user_recno , long msgid);
long  NumMsgs(short areanum);
long  HighMsg(short areanum);
long  MsgNum(short areanum , long id);
long  MsgId (short areanum , long num);
BOOL  ReadMessage(MESSAGE *msg,long msgid,short areanum);
void  WriteMSGTMP(const char *text);
void  AppendMSGTMP(const char *text);
void  ShowMessage(const MESSAGE *msg);
void  CreateMessageText(const MESSAGE *msg);
void  CreateMessageTextString(const MESSAGE *msg,char *text,short maxsize);
BOOL  FirstMessage(MESSAGE *msg,short area,short order,long first);
BOOL  NextMessage(MESSAGE *msg,short area,short order);
void  DeleteMessage(MESSAGE *msg);
void  MarkMessage(short area,long msgid);
void  ReadMarkedMessages(void);
void  ListMarkedMessages(void);
void  UnMarkAllMessages(void);
//....................................................time handling functions
void  AddTime(short plusminus);
short TimeLeft(void);
short TimeOnline(void);
void  SuspendTimer(void);
void  RestartTimer(void);
void  AdjustTime(void);
short TimeUntilEvent(void);
//................................................low-level IO (undocumented)
BOOL   IO_SendByte(uchar);   /* TRUE = byte sent, FALSE = buffer full */
short  IO_ReadByte(void);    /* Returns -1 if no byte available       */
BOOL   IO_Carrier(void);     /* TRUE = carrier available              */
BOOL   IO_ByteReady(void);   /* TRUE = byte available in input buffer */
BOOL   IO_BufEmpty(void);    /* TRUE = output buffer is empty         */
void   IO_StartBreak(void);  /* Start sending a break                 */
void   IO_StopBreak(void);   /* Stop sending a break                  */
void   IO_DTR(BOOL);         /* Set/lower DTR line (TRUE = set)       */
ushort IO_SendBlock(uchar *b,ushort n); /* Send block of bytes, returns # actually sent */
ushort IO_ReadBlock(uchar *b,ushort n); /* Read block of bytess, returns # actually read */
//......................................................various I/O functions
char WaitKey(void);
char WaitKeys(const char *);
void Input(char *buf,short len,short readmode);
BOOL Ask(BOOL def);
char PeekChar(void);
void SetColor(char color);
void SetFullColor(uchar color);
void GotoXY(short x,short y);
void ClrEol(void);
void EnableStop(void);
void DisableStop(void);
BOOL Stopped(void);
BOOL ExternalInput(void);
char ShowHotkeyFile(const char *fname,const char *hotkeys);
char ShowHotkeyANSIFile(const char *fname,const char *hotkeys);
BOOL ShowRIPscrip(char *fn);
void InitLineCounter(void);
BOOL LineCounter(void);
void ResetInactivity(void);
BOOL LocalDisplay( BOOL );
BOOL RemoteDisplay( BOOL );
BOOL RIP(void);
//.................................................userbase support functions
BOOL ReadUser(USER_REC *rec,long recnr);
void WriteUser(const USER_REC *rec);
BOOL SetUser(long recnr);
//.................................................filebase support functions
short ReadFileArea(short area,FILEAREA *ma);
short NumFileAreas(void);
short GetTaggedFiles(TAGGED_FILE *array,short max);
BOOL  PutTaggedFiles(TAGGED_FILE *array,short n);
BOOL  AddTaggedFile(TAGGED_FILE *tag);
BOOL  RemoveTaggedFile(TAGGED_FILE *tag);
void  ClearTaggedFiles();
BOOL  IsTagged(TAGGED_FILE *tag);
//..........................................................general functions
short FuzzySearch(char *text,char *search,short degree);
char  PlayMusic(const char *fname,const char *hotkeys);
void  PostInfo(const char *fname);
long  MemAvail(void);
void  MenuFunction(short,const char *);
void  Log(short loglevel,const char *fmtstring,...);
void  HangUp(void);
BOOL  CheckAccess(ushort level,accessflags flags);
KEY   ScanKey(void);
void  exit(void);
void  ExitTSR(void);
short ErrorLevel(void);
BOOL  GetIniVar(char *fname,char *varname,char *value,short max);
BOOL  SetIniVar(char *fname,char *varname,char *value);
short _InstallHandler(short handler,short (*func)(void),unsigned ds);
void  _RemoveHandler(short handler,short (*func)(void),unsigned ds);
#define InstallHandler(handler,func) _InstallHandler(handler,(short (*)(void))(func),FP_SEG(&NetEntered));
#define RemoveHandler(handler,func)  _RemoveHandler(handler,(short (*)(void))(func),FP_SEG(&NetEntered));
//.....................................................undocumented functions
void ParseStringVars(char *input,char *result,short max_len);

#ifdef __cplusplus
	}
#endif


#else  /*............................................PB_SDK is not defined */

//.....................get rid of the annoying long math functions in the SDK
#define l_mul(v1,v2)   ( (long)(v1) * (v2)         )
#define l_div(v1,v2)   ( (long)(v1) / (v2)         )
#define l_mod(v1,v2)   ( (long)(v1) % (v2)         )
#define l_shl(v,s)     ( (long)(v) << (ushort)(s)  )
#define l_shr(v,s)     ( (long)(v) >> (ushort)(s)  )
#define ul_div(v1,v2)  ( (ulong)(v1) / (v2)        )
#define ul_mod(v1,v2)  ( (ulong)(v1) % (v2)        )
#define ul_shl(v,s)    ( (ulong)(v) << (ushort)(s) )
#define ul_shr(v,s)    ( (ulong)(v) >> (ushort)(s) )

//..................these are all fake, in offline mode, we don't do modem IO
inline BOOL   IO_SendByte(uchar){ return FALSE; }
inline short  IO_ReadByte(void){ return -1; }
inline BOOL   IO_Carrier(void){ return FALSE; }
inline BOOL   IO_ByteReady(void){ return FALSE; }
inline BOOL   IO_BufEmpty(void){ return TRUE; }
inline void   IO_DTR(BOOL){ ; }
inline ushort IO_SendBlock(uchar,ushort){ return 0; }
inline ushort IO_ReadBlock(uchar,ushort){ return 0; }
#define       IO_StartBreak()
#define       IO_StopBreak()

//...........................................sorry, the handlers are fake too
#define _InstallHandler(h,f,s)
#define _RemoveHandler(h,f,s)
#define  InstallHandler(h,f)
#define  RemoveHandler(h,f)

/*
 * These are fake too, there's no need for that in the exe. There's no
 * need to 'AdjustTime' either because if you modify CurUser, that's it!
*/
#define  SuspendTimer()
#define  RestartTimer()
#define  AdjustTime()

//.....................................these will map onto standard functions
#define	GotoXY(x,y)     gotoxy(x,y)
#define ClrEol()        clreol()
#define SetFullColor(a) textattr(a)
#define HangUp()        exit(EXIT_SUCCESS)

//...........................these are the ones that are actually implemented
BOOL  ReadMsgArea(int recno, MSGAREA *rec);
short NumMsgAreas(void);
int   ReadFileArea(int recno, FILECFG *rec);
int   PeekChar(void);
short NumFileAreas(void);
short GetTaggedFiles(TAGGED_FILE *array,short max);
BOOL  PutTaggedFiles(TAGGED_FILE *array,short n);
BOOL  AddTaggedFile(TAGGED_FILE *tag);
BOOL  RemoveTaggedFile(TAGGED_FILE *tag);
void  ClearTaggedFiles();
BOOL  IsTagged(TAGGED_FILE *tag);
BOOL  GetIniVar(char *fname, char *var, char *value, int len);
BOOL  SetIniVar(char *fname, char *var, char *value);
void  Log(int loglevel, char *format, ...);
BOOL  ReadUser(USER_REC *rec, long recno);
void  WriteUser(USER_REC *rec);
BOOL  SetUser(long recno);
char  PlayMusic(const char *fileName, const char *hotkeys);
void  Input(char *buf, int len, int mode);
short FuzzySearch(char *text, char *search, short degree);
BOOL  CheckAccess(ushort level, accessflags flags);
char  WaitKey();
char  WaitKeys(const char *keys);
void  WriteMSGTMP(char *text);
void  AppendMSGTMP(char *text);
void  AddTime(int plusminus);
int   TimeLeft();
int   TimeOnline();
int   TimeUntilEvent();
void  ParseStringVars(char *input, char *result, short maxlen);
long  GetLastRead(short areanum, long user_recno);
long  NumMsgs(short areanum);
long  HighMsg(short areanum);
char  ShowHotkeyFile(const char *fname, const char *hotkeys);
char  ShowHotkeyANSIFile(const char *fname, const char *hotkeys);

#endif /*...........................................for PB_SDK not defined */

/*
 * a v a i l a b l e   f o r   p e x   a n d   e x e   m o d e
 * 
 * these routines are available to both pexen and exe programs. these are the
 * actual ports of the SDK to the exe version of pb-lib and the original SDK.
*/

//..........................................................modes for Input()
#define INPUT_ALL       0 //.............all characters allowed in the string
#define INPUT_UPFIRST   1 //...............first chars of words to upper-case
#define INPUT_UPALL     2 //.............convert all characters to upper-case
#define INPUT_DIGITS    3 //..................allow digits only in the string
#define INPUT_PWD      64 //...........password mode: display pwdchar instead
#define INPUT_NOFIELD 128 //...............don't display the background color

//...............................parameters for SetColor() - changed names!!!
#define SC_BLACK   0x00   //.................................black foreground
#define SC_RED     0x01   //...................................red foreground
#define SC_GREEN   0x02   //.................................green foreground
#define SC_YELLOW  0x03   //................................yellow foreground
#define SC_MAGENTA 0x04   //...............................magenta foreground
#define SC_BLUE    0x05   //..................................blue foreground
#define SC_CYAN    0x06   //..................................cyan foreground
#define SC_WHITE   0x07   //.................................white foreground
#define SC_BLINK   0x10   //..................OR together for flashing colors

//........................parameters for MenuFunction() - refer to the manual
#define MENU_GOTOMENU                1
#define MENU_GOSUBMENU               2
#define MENU_PREVMENU                3
#define MENU_GOTOMENUCLEAR           4
#define MENU_SHOWANSASC              5
#define MENU_COUNTRY_CHANGE          6
#define MENU_SHELL                   7
#define MENU_VERSION_INFO            8
#define MENU_LOGOFF                  9
#define MENU_USAGE_GRAPH            10
#define MENU_PAGESYSOP              11
#define MENU_QUESTIONNAIRE          12
#define MENU_USER_LIST              13
#define MENU_TIME_STAT              14
#define MENU_VIEW_ANS_WAIT          15
#define MENU_CITY_CHANGE            16
#define MENU_PASSWORD_CHANGE        17
#define MENU_LINES_CHANGE           18
#define MENU_CLS_TOGGLE             19
#define MENU_PAUSE_TOGGLE           20
#define MENU_ANSI_TOGGLE            21
#define MENU_MAILCHECK              22
#define MENU_READMSG                23
#define MENU_SCAN_MSG               24
#define MENU_QSCAN_MSG              25
#define MENU_DAYS_GRAPH             26
#define MENU_WRITEMSG               27
#define MENU_COMBINED_SELECT        28
#define MENU_WEEKS_GRAPH            29
#define MENU_RAW_DIR                30
#define MENU_LIST_FILES             31
#define MENU_DOWNLOAD               32
#define MENU_UPLOAD                 33
#define MENU_LIST_ARCHIVE           34
#define MENU_KEYWORD_SEARCH         35
#define MENU_FILENAME_SEARCH        36
#define MENU_NEW_FILES              37
#define MENU_VIEW_FILE              38
#define MENU_VIEW_NAMED_FILE        39
#define MENU_FSED_TOGGLE            41
#define MENU_HOTKEY_TOGGLE          42
#define MENU_CLEARMARKED            43
#define MENU_COMBINED_CLEAR         44
#define MENU_VIEW_FILE_WAIT         45
#define MENU_CHANGE_ACCESS          46
#define MENU_LOGENTRY               47
#define MENU_TOPS                   48
#define MENU_SET_MSGAREA            49
#define MENU_SHOW_USERS_ONLINE      50
#define MENU_LASTCALLERS            51
#define MENU_USEREDITOR             52
#define MENU_MULTICHAT              53
#define MENU_SET_FILEAREA           54
#define MENU_VIEW_GIF               55
#define MENU_IBM_TOGGLE             56
#define MENU_PHONE_CHANGE           57
#define MENU_DATAPHONE_CHANGE       58
#define MENU_HANDLE_CHANGE          59
#define MENU_RUN_SDKFILE            60
#define MENU_SHOW_BULLETIN          61
#define MENU_AVT0                   62
#define MENU_AVT1                   63
#define MENU_SHOW_GRAPH             64
#define MENU_RIP_FONT               66
#define MENU_RIP_GRAPHICS           67
#define MENU_EDIT_TAGGED            68
#define MENU_SELECT_LANGUAGE        69
#define MENU_CHANGE_DATE_FORMAT     70
#define MENU_CHANGE_MAILING_ADDRESS 71
#define MENU_CHANGE_FAX_NUMBER      72
#define MENU_CHANGE_COUNTRY         73
#define MENU_SET_PROTOCOL           74
#define MENU_SET_MSGGROUP           75
#define MENU_SET_FILEGROUP          76

//...................................keyboard handler modes and return values
#define NOT_HANDLED       0
#define HANDLED           1
#define HANDLER_SYSOPKEY  6
#define HANDLER_HANGUP    7

//........................................................codes for ScanKey()
#define KEY_F1    0x3B00U
#define KEY_F2    0x3C00U
#define KEY_F3    0x3D00U
#define KEY_F4    0x3E00U
#define KEY_F5    0x3F00U
#define KEY_F6    0x4000U
#define KEY_F7    0x4100U
#define KEY_F8    0x4200U
#define KEY_F9    0x4300U
#define KEY_F10   0x4400U
#define KEY_SF1   0x5400U
#define KEY_SF2   0x5500U
#define KEY_SF3   0x5600U
#define KEY_SF4   0x5700U
#define KEY_SF5   0x5800U
#define KEY_SF6   0x5900U
#define KEY_SF7   0x5A00U
#define KEY_SF8   0x5B00U
#define KEY_SF9   0x5C00U
#define KEY_SF10  0x5D00U
#define KEY_CF1   0x5E00U
#define KEY_CF2   0x5F00U
#define KEY_CF3   0x6000U
#define KEY_CF4   0x6100U
#define KEY_CF5   0x6200U
#define KEY_CF6   0x6300U
#define KEY_CF7   0x6400U
#define KEY_CF8   0x6500U
#define KEY_CF9   0x6600U
#define KEY_CF10  0x6700U
#define KEY_AF1   0x6800U
#define KEY_AF2   0x6900U
#define KEY_AF3   0x6A00U
#define KEY_AF4   0x6B00U
#define KEY_AF5   0x6C00U
#define KEY_AF6   0x6D00U
#define KEY_AF7   0x6E00U
#define KEY_AF8   0x6F00U
#define KEY_AF9   0x7000U
#define KEY_AF10  0x7100U
#define KEY_ALT1  0x7800U
#define KEY_ALT2  0x7900U
#define KEY_ALT3  0x7A00U
#define KEY_ALT4  0x7B00U
#define KEY_ALT5  0x7C00U
#define KEY_ALT6  0x7D00U
#define KEY_ALT7  0x7E00U
#define KEY_ALT8  0x7F00U
#define KEY_ALT9  0x8000U
#define KEY_ALT0  0x8100U
#define KEY_ALTA  0x1E00U
#define KEY_ALTB  0x3000U
#define KEY_ALTC  0x2E00U
#define KEY_ALTD  0x2000U
#define KEY_ALTE  0x1200U
#define KEY_ALTF  0x2100U
#define KEY_ALTG  0x2200U
#define KEY_ALTH  0x2300U
#define KEY_ALTI  0x1700U
#define KEY_ALTJ  0x2400U
#define KEY_ALTK  0x2500U
#define KEY_ALTL  0x2600U
#define KEY_ALTM  0x3200U
#define KEY_ALTN  0x3100U
#define KEY_ALTO  0x1800U
#define KEY_ALTP  0x1900U
#define KEY_ALTQ  0x1000U
#define KEY_ALTR  0x1300U
#define KEY_ALTS  0x1F00U
#define KEY_ALTT  0x1400U
#define KEY_ALTU  0x1600U
#define KEY_ALTV  0x2F00U
#define KEY_ALTW  0x1100U
#define KEY_ALTX  0x2D00U
#define KEY_ALTY  0x1500U
#define KEY_ALTZ  0x2C00U
#define KEY_CTLA  0x0001U
#define KEY_CTLB  0x0002U
#define KEY_CTLC  0x0003U
#define KEY_CTLD  0x0004U
#define KEY_CTLE  0x0005U
#define KEY_CTLF  0x0006U
#define KEY_CTLG  0x0007U
#define KEY_CTLH  0x0008U
#define KEY_CTLI  0x0009U
#define KEY_CTLJ  0x000AU
#define KEY_CTLK  0x000BU
#define KEY_CTLL  0x000CU
#define KEY_CTLM  0x000DU
#define KEY_CTLN  0x000EU
#define KEY_CTLO  0x000FU
#define KEY_CTLP  0x0010U
#define KEY_CTLQ  0x0011U
#define KEY_CTLR  0x0012U
#define KEY_CTLS  0x0013U
#define KEY_CTLT  0x0014U
#define KEY_CTLU  0x0015U
#define KEY_CTLV  0x0016U
#define KEY_CTLW  0x0017U
#define KEY_CTLX  0x0018U
#define KEY_CTLY  0x0019U
#define KEY_CTLZ  0x001AU
#define KEY_DEL   0x5300U
#define KEY_INS   0x5200U
#define KEY_HOME  0x4700U
#define KEY_END   0x4F00U
#define KEY_PGUP  0x4900U
#define KEY_PGDN  0x5100U
#define KEY_UP    0x4800U
#define KEY_DN    0x5000U
#define KEY_LT    0x4B00U
#define KEY_RT    0x4D00U
#define KEY_ESC   0x001BU
#define KEY_ENT   0x000DU
#define KEY_RET   0x000DU
#define KEY_TAB   0x0009U
#define KEY_STAB  0x0F00U
#define KEY_CPGUP 0x8400U
#define KEY_CPGDN 0x7600U

//...............................flags for GetFlag(), SetFlag and ClearFlag()
#define FLAG_A  1
#define FLAG_B  2
#define FLAG_C  3
#define FLAG_D  4
#define FLAG_E  5
#define FLAG_F  6
#define FLAG_G  7
#define FLAG_H  8
#define FLAG_I  9
#define FLAG_J 10
#define FLAG_K 11
#define FLAG_L 12
#define FLAG_M 13
#define FLAG_N 14
#define FLAG_O 15
#define FLAG_P 16
#define FLAG_Q 17
#define FLAG_R 18
#define FLAG_S 19
#define FLAG_T 20
#define FLAG_U 21
#define FLAG_V 22
#define FLAG_W 23
#define FLAG_X 24
#define FLAG_Y 25
#define FLAG_Z 26
#define FLAG_1 27
#define FLAG_2 28
#define FLAG_3 29
#define FLAG_4 30
#define FLAG_5 31
#define FLAG_6 32

#ifdef __cplusplus

inline BOOL GetFlag(ulong fs,short f){ return ((fs & ul_shl(1,32-f))?TRUE:FALSE);}
inline void SetFlag(ulong &fs,short f){ fs |= ul_shl(1,32-f); }
inline void ClearFlag(ulong &fs,short f){fs &= ~ul_shl(1, 32-f);}
inline void InitMessage(MESSAGE *msg){ memset(msg,0,sizeof(MESSAGE)); }

#else

#define GetFlag(flags,flag)   (((flags) &   ul_shl(1,32-(flag)))?TRUE:FALSE)
#define SetFlag(flags,flag)   { (flags) |=  ul_shl(1,32-(flag)); }
#define ClearFlag(flags,flag) { (flags) &= ~ul_shl(1,32-(flag)); }

#endif /* C++ mode for inline functions, #define otherwise */

//..................................................global ProBoard variables
extern USER_REC     * const CurUser;      /* Current user online        RW */
extern short          const UserRecNr;    /* Record # of current user   RO */
extern short          const NumLimits;    /* # limits in limits[] array RO */
extern LIMIT  const * const Limits;       /* Limits per level           RO */
extern char         * const LoginDate;    /* Login date of user         RW */
extern char         * const LoginTime;    /* Login time of user         RW */
extern BOOL           const NetEntered;   /* Netmail entered            RO */
extern BOOL           const EchoEntered;  /* Echomail entered           RO */
extern short          const NumUsers;     /* # users in userfile        RO */
extern short          const NodeNumber;   /* Current node number        RO */
extern char   const * const CurMenu;      /* Current menu name          RO */
extern char   const * const UserFirstName;/* First name of current user RO */
extern char   const * const PrevUser;     /* Name of previous user      RO */
extern char   const * const StartupPath;  /* Startup path               RO */
extern char   const * const SysPath;      /* ProBoard system path       RO */
extern CONFIG const * const Config;       /* ProBoard config-record     RO */
extern ushort         const PBVersion;    /* Version number of ProBoard RO */
extern long           const BaudRate;     /* Baud rate (0=local)        RO */
extern ushort         const Beta;         /* Beta nr (0xFFFF=release)   RO */
extern char         * const PageReason;   /* Reason for sysop paging    RW */
extern ushort       * const PageCount;    /* Number of sysop pages      RW */

#endif /* INCLUDED_PBLSDK_H */
