/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#ifndef INCLUDED_FILE_H
#define INCLUDED_FILE_H
#include "typedef.h"

#ifdef PB_SDK
	#include "pblibc.h"
#else
	#include <stdio.h>
#endif

/*
 * f i l e   s  y s t e m   u t i l i t y   r o u t i n e s
 * 
 * various file, file name specifications and directory related functions
*/

char    *file_appchr( char *dest, const char *src, char aChar = '\\' );
int      file_append( const char *dest, const char *src );
Boolean  file_backup( const char *fileName );
int      file_chdir( char *path );
char    *file_chext( char *dest, const char *src, const char *ext );
int      file_cmpdate( const char *p1, const char *p2 );
int      file_copy( const char *dest, const char *src );
Boolean  file_direxist( const char *dirSpec );
char    *file_dirspec( const char *path );
Boolean  file_exist( const char *fileName );
Boolean  file_extend( const char *fileName, long width );
#define  file_killempty(path) if( 0 == file_size(path) ) file_remove(path)
int      file_mkdir( char *path );
char    *file_name( const char *path );
int      file_remove( const char *spec );
int      file_rename( const char *oldname, const char *newname );
int      file_rmdir( char *path );
char    *file_scan( const char *pathList, const char *fileName );
long     file_size( const char *fileSpec );
char    *file_tempname( void );
char    *file_unique( char *path );

// read a record from a typed binary file, records are numbered from 0
template <class Type>
inline Boolean
file_read(FILE *fp, Type *rec, long recno = -1)
{
	if( -1 != recno ) fseek(fp, recno * (long)sizeof(Type), SEEK_SET);
	return Boolean( 1 == fread(rec, sizeof(Type), 1, fp) );
}

// write a record to a typed binary file
template <class Type>
inline Boolean
file_write(FILE *fp, Type *rec, long recno = -1)
{
	if( -1 != recno ) fseek(fp, recno * (long)sizeof(Type), SEEK_SET);
	return Boolean( 1 == fwrite(rec, sizeof(Type), 1, fp) );
}

#endif /* INCLUDED_FILE_H */
