/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#ifndef INCLUDED_PROBOARD_H
#define ICNLUDED_PROBOARD_H

#include "pbstruct.h"

#ifndef PB_SDK
	#include <stdio.h>
	#include <time.h>
#else
	#include "pblibc.h"
#endif

/*
 * p r o b o a r d - r e l a t e d   u t i l i t y   f u n c t i o n s
 * 
 * functions which are unique to the proboard programming environment pex/exe
*/

enum pbdir_t {       //.................enumerations for proboard directories
	PBDIR_SYS,       //..................................the system directory
	PBDIR_PEX,       //.....................................the pex directory
	PBDIR_USER,      //................................the userbase directory
	PBDIR_TEXT,      //.......................the display textfiles directory
	PBDIR_MENU,      //....................................the menu directory
	PBDIR_MSGBASE,   //......................................same as userbase
	PBDIR_NODELIST,  //................................the nodelist directory
	PBDIR_STARTUP,   //.................................the startup directory
	PBDIR_UPLOAD,    //..........................the default upload directory
	PBDIR_PVTUPLOAD, //..........................the private upload directory
	PBDIR_RIPFILES,  //...............................the RIP files directory
	PBDIR_RIPICONS   //...............................the RIP icons directory
};

enum flagformat_t {  //...................enumeration for the flag formatting
	FLAGFMT_ALL,     //.....................all flags formatted into a string
	FLAGFMT_A,       //...........................only A to H flags formatted
	FLAGFMT_B,       //...........................only I to P flags formatted
	FLAGFMT_C,       //...........................only Q to X flags formatted
	FLAGFMT_D        //...........................only Y to 6 flags formatted
};
/*
 * c o n s t a n t   f o r   f i l e   d i s p l a y   r o u t i n e s
 * 
 * this is the number of cycles the file display routines will skip before
 * looking for input. larger values speed up the display but also make the
 * response rate slower. lower values slow down the display but make the
 * response rate snappier. the 2,400 default is good for most needs
*/
#define MAX_CYCLES 2400  //..............constant for text file display speed
/*
 * file and directory related routines (for the proboard config)
*/
char* pb_getdir(pbdir_t where);
char* pb_getpath(const char *fname, pbdir_t where);
FILE* pb_fopen(const char *fname, const char *mode, pbdir_t where);
char* pb_menukeys(const char *menu);
/*
 * convert between proboard and ra-style flags, time, and date
*/
void  pb2raDate(DateRaType ra, const DateType pb);
void  pb2raTime(TimeRaType ra, const TimeType pb);
void  pb2raFlags(uchar *raFlags, ulong pbFlags);
void  ra2pbDate(DateType pb, const DateRaType ra);
void  ra2pbTime(TimeType pb, const TimeRaType ra);
ulong ra2pbFlags(const uchar *aFlags);
/*
 * process date and time in proboard style formatting
*/
void  pb_curdate(DateType dest);
void  pb_mkdate(DateType dest, time_t timer);
char* pb_fmtdate(DateType pbDate);
void  pb_curtime(TimeType dest);
void  pb_mktime(TimeType dest, time_t timer);
char* pb_fmttime(TimeType pbTime);
/*
 * various utility routines
*/
Boolean      pb_group(int groupno, GROUP_PB *pGroup, Boolean msg = False);
char*        pb_flagformat(flagformat_t how, ulong flags);
const LIMIT* pb_limit(ushort level);
Boolean      pb_access(ushort level, ulong flags, ulong flagsNot);
Boolean      pb_pagestat(const struct tm *slot = 0);
void         pb_askenter();
void         pb_runpex(const char *command);
void         pb_runexe(const char *command);
Boolean      pb_ver(int *maxver, int *minver, int *beta);
int          pb_isgfx();

class zTerminal;
void         pb_showlang(int promptno, zTerminal * const pTerminal);
int          pb_askmore(zTerminal * const pTerminal);
int          pb_showfile(char *name, char *keys, zTerminal * const pTerm);
int          pb_showfile(char *name, char *keys, char *dir, zTerminal * const pTerm);

#endif /* INCLUDED_PROBOARD_H */
