/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#ifndef INCLUDED_PBLIBC_H
#define INCLUDED_PBLIBC_H

#include "typedef.h"

#ifndef PB_SDK
	#error "This module should be used for SDK programs only!"
#else
typedef void far *va_list;
/*
 * s d k   v e r s i o n s   o f   s t a n d a r d   r o u t i n e s
 * 
 * this is the header file for all standard C library routines which are not
 * originally available in the sdk. they have all been implemented in PB-Lib
*/
#ifdef __cplusplus
	extern "C" {
	#define __CPPARGS ...
#else
	#define __CPPARGS
#endif

//..............................the standard proboard SDK CRTL implementation
#define NULL  (0L)
#define FAR   far

typedef int    FILE;
typedef long   clock_t;
typedef long   time_t;

struct find_t{           /* dos_findfirst() & dos_findnext() */
	char   reserved[21]; /* reserved by DOS                  */
	char   attrib;       /* attribute found (FA_XXXX)        */
	uint   time,date;    /* file's last write                */
	ulong  size;         /* file's size                      */
	char   name[13];     /* filename followed by 0 byte      */
};

#define FA_NORMAL   0x00
#define FA_RDONLY	0x01
#define FA_HIDDEN	0x02
#define FA_SYSTEM	0x04
#define FA_LABEL	0x08
#define FA_DIREC	0x10
#define FA_ARCH		0x20

#define FP_SEG(fp)	  ((uint)((ulong)(fp) >> 16))
#define FP_OFF(fp)    ((uint)((ulong)(fp)))
#define MK_FP(sg,ofs) ((void FAR *)(((ulong)(sg)<<16) | (uint)(ofs)))

struct WREGS{ unsigned ax,bx,cx,dx,si,di,cflag,flags; };
struct BREGS{ unsigned char  al,ah,bl,bh,cl,ch,dl,dh; };
union  REGS { struct WREGS x; struct BREGS h; };
struct SREGS{ unsigned es,cs,ss,ds; };

extern int errno;

#define ENOENT  2
#define ENOTDIR	3
#define EMFILE	4
#define EACCES	5
#define EBADF	6
#define ENOMEM	8
#define EINVAL	22
#define EEXIST	80
#define E2BIG	1000
#define ENOEXEC	1001
#define EDOM	1002
#define	ERANGE	1003

#define O_RDONLY    0
#define O_WRONLY	1
#define O_RDWR		2

#define O_NOINHERIT 0x80
#define O_DENYALL   0x10
#define O_DENYWRITE 0x20
#define O_DENYREAD  0x30
#define O_DENYNONE  0x40

#define S_IREAD  0x0100
#define S_IWRITE 0x0080

#define O_BINARY 0

#define _IOFBF   0
#define _IOLBF   1
#define _IONBF   2

#define F_OK    0   /* does file exist?    */
#define X_OK	1	/* execute permission? */
#define W_OK	2	/* write permission?   */
#define R_OK	4	/* read permission?	   */

#define SEEK_SET 0 /* seek from start of file      */
#define SEEK_CUR 1 /* relative to current position */
#define SEEK_END 2 /* relative to end of file      */

struct tm{
	int tm_sec;         /* seconds 0..59                        */
	int tm_min;         /* minutes 0..59                        */
	int tm_hour;        /* hour of day 0..23                    */
	int tm_mday;        /* day of month 1..31                   */
	int tm_mon;         /* month 0..11                          */
	int tm_year;        /* years since 1900                     */
	int tm_wday;        /* day of week, 0..6 (Sunday..Saturday) */
	int tm_yday;        /* day of year, 0..365                  */
	int tm_isdst;       /* >0 DST, == no DST, <0 don't know     */
};

FILE*  fopen(const char *,const char *);
FILE*  freopen(const char *,const char *,FILE *);
int    fseek(FILE *,long,int);
long   ftell(FILE *);
char*  fgets(char *,int,FILE *);
int    fgetc(FILE *);
int    fflush(FILE *);
int    fclose(FILE *);
int    fputs(const char *,FILE *);
int    getc(FILE *);
int    getchar(void);
char*  gets(char *);
int    fputc(int,FILE *);
int    putc(int,FILE *);
int    putchar(int);
int    puts(const char *);
size_t fread(void *,size_t,size_t,FILE *);
size_t fwrite(const void *,size_t,size_t,FILE *);
int    printf(const char *,...);
int    fprintf(FILE *,const char *,...);
int    vfprintf(FILE *,const char *,va_list);
int    vprintf(const char *,va_list);
int    sprintf(char *,const char *,...);
int    vsprintf(char *,const char *,va_list);
void   setbuf(FILE *,char *);
int    setvbuf(FILE *,char *,int,size_t);
int    remove(const char *);
int    rename(const char *,const char *);
void   rewind(FILE *);
void   clearerr(FILE *);
int    feof(FILE *);

int    isalnum(int);
int    isalpha(int);
int    iscntrl(int);
int    isdigit(int);
int    isgraph(int);
int    islower(int);
int    isprint(int);
int    ispunct(int);
int    isspace(int);
int    isupper(int);
int    isxdigit(int);
int    toupper(int);
int    tolower(int);

int    int86(int,union REGS *,union REGS *);
int    int86x(int,union REGS *,union REGS *,struct SREGS *);
int    intdos(union REGS *,union REGS *);
int    intdosx(union REGS *,union REGS *,struct SREGS *);
int    dos_findfirst(const char *, unsigned, struct find_t *);
int    dos_findnext(struct find_t *);

int    mkdir(const char *);
int    rmdir(const char *);
int    chdir(const char *);

int    read(int,void *,unsigned);
int    write(int,const void *,unsigned);
int    open(const char *,int);
int    creat(const char *,int);
int    close(int);
int    unlink(const char *);
int    chsize(int, long);
int    dup(int);
int    dup2(int, int);
long   lseek(int,long,int);
int    access(const char *,int);
long   filelength(int);
int    isatty(int);

int    atoi(const char *);
long   atol(const char *);
long   strtol(const char *,char **,int);
int    rand(void);
void   srand(unsigned);
void * calloc(size_t,size_t);
void   free(void *);
void * malloc(size_t);
void * realloc(void *,size_t);
char * getenv(const char *);
int    putenv(const char *);
int    abs(int);
long   labs(long);

void * memcpy(void *,const void *,size_t);
void * memmove(void *,const void *,size_t);
char * strcpy(char *,const char *);
char * strncpy(char *,const char *,size_t);
char * strcat(char *,const char *);
char * strncat(char *,const char *,size_t);
int    memcmp(const void *,const void *,size_t);
int    strcmp(const char *,const char *);
int    strncmp(const char *,const char *,size_t);
void * memchr(const void *,int,size_t);
char * strchr(const char *,int);
size_t strcspn(const char *,const char *);
char * strpbrk(const char *,const char *);
char * strrchr(const char *,int);
size_t strspn(const char *,const char *);
char * strstr(const char *,const char *);
char * strtok(char *,const char *);
void * memset(void *,int,size_t);
size_t strlen(const char *);

int    memicmp(const void *,const void *,size_t);
char * stpcpy(char *,const char *);
int    strcmpl(const char *,const char *);
int    strnicmp(const char *,const char *, size_t);
char * strdup(const char *);
char * strlwr(char *);
char * strupr(char *);
char * strnset(char *,int,size_t);
char * strrev(char *);
char * strset(char *,int);
void   swab(char *,char *,size_t);

#define strncmpl(a,b,c) strnicmp((a),(b),(c))
#define stricmp(a,b)    strcmpl((a),(b))
#define delay(a)        msleep(a)

clock_t clock(void);
time_t  time(time_t *);
time_t  mktime(struct tm *);
char *  asctime(const struct tm *);
char *  ctime(time_t *);
size_t  strftime(char *,size_t,const char *,struct tm *);
struct tm* localtime(const time_t *);
struct tm* gmtime(const time_t *);

#define difftime(t1,t2)   (((time_t)(t1) - (time_t)(t2)))

void sleep(time_t);
void usleep(unsigned long);
void msleep(unsigned long);
/*
//..........................constants that are missing plus fixes for the SDK
*/
#define EOF              -1     //..................this one was missing too!
#define BUFSIZ          512     //.............this is the normal buffer size
#define EXIT_FAILURE            //..........fix the glaringly non-ANSI exit()
#define EXIT_SUCCESS            //...............by providing dummy constants
#define RAND_MAX        0x7FFFU //..................for the random() function

//..........................the following fixes the buggy SDK version of varg
#define _sz(t)        ( (sizeof(t)+1) & 0xFFFE )
#define va_start(a,f) ((void)((a) = (va_list)((char far *)(&f)+_sz(f))))
#define va_arg(a,t)   (*(t far*)(((*(char far* far*)&(a))+=_sz(t))-(_sz(t))))
#define va_end(a)     ( (void)0 )

//.....................................................special macro mappings
#define disable()   __emit__( 0xfa )        //.............disable interrupts
#define enable()    __emit__( 0xfb )        //..............enable interrupts
#define isascii(c)  (unsigned(c) < 128)     //..........is this an ASCii char

//....................................................constants for bioskey()
#define _KEYBRD_READ         0x00  //.........standard BIOS: wait & read char
#define _KEYBRD_READY        0x01  //............standard BIOS: test for char
#define _KEYBRD_SHIFTSTATUS  0x02  //...........standard BIOS: get shift keys
#define _NKEYBRD_READ        0x10  //.........extended BIOS: wait & read char
#define _NKEYBRD_READY       0x11  //............extended BIOS: test for char
#define _NKEYBRD_SHIFTSTATUS 0x12  //...........extended BIOS: get shift keys

/*
 * these are the bit masks for the 'st_mode' field in the stat structure
 * note that S_IREAD and S_IWRITE are already defined in the SDK section!
*/
#define S_IFMT  0xF000  //.....................................file type mask
#define S_IFDIR 0x4000  //..........................................directory
#define S_IFIFO 0x1000  //................................FIFO special device
#define S_IFCHR 0x2000  //...........................character special device
#define S_IFBLK 0x3000  //......................................block special
#define S_IFREG 0x8000  //............................or just 0x0000, regular
#define S_IEXEC 0x0040  //...............owner may execute <directory search>

//...........................these are conio.h prototypes mapped onto the SDK
#define textattr(a) SetFullColor(a)
#define gotoxy      GotoXY
#define clrscr()	printf("\f")
#define clreol()    ClrEol()
#define cprintf     printf
#define cputs       puts
#define putch       putchar

//.........................................from stdlib.h randomization macros
#define randomize() srand(unsigned(time(NULL)))
#define random(n)   (int)( ((long)rand()*n) / (RAND_MAX+1) )

//...............................................structure for _dos_getdate()
struct dosdate_t
{
	unsigned char day;         //.................................day: 1 - 31
	unsigned char month;       //...............................month: 1 - 12
	unsigned int  year;        //...........................year: 1980 - 2099
	unsigned char dayofweek;   //.............day of week: 0 - 6 (0 = Sunday)
};

//...............................................structure for _dos_gettime()
struct dostime_t
{
	unsigned char hour;         //......................................hours
	unsigned char minute;       //....................................minutes
	unsigned char second;       //....................................seconds
	unsigned char hsecond;      //......................hundredths of seconds
};

struct stat
{
	short  st_dev;    //...............drive number of disk that has the file
	short  st_ino;    //.........not meaningful under MS-DOS (UNIX inode no.)
	short  st_mode;   //.............bit mask that has info about file's mode
	short  st_nlink;  //...................always set to integer constant = 1
	int    st_uid;    //...........not meaningful under MS-DOS (UNIX user id)
	int    st_gid;    //..........not meaningful under MS-DOS (UNIX group id)
	short  st_rdev;   //.......................................same as st_dev
	long   st_size;   //.....................size of the (open) file in bytes
	long   st_atime;  //................most recent time of file modification
	long   st_mtime;  //........................same as st_atime under MS-DOS
	long   st_ctime;  //........................same as st_atime under MS-DOS
};

//...................................................structure for getdfree()
struct dfree
{
	unsigned df_avail;  //.................................available clusters
	unsigned df_total;  //.....................................total clusters
	unsigned df_bsec;   //...................................bytes per sector
	unsigned df_sclus;  //................................sectors per cluster
};

//....................................structure for getftime() and setftime()
struct ftime
{
	unsigned ft_tsec  : 5;  //....................................two seconds
	unsigned ft_min   : 6;  //........................................minutes
	unsigned ft_hour  : 5;  //..........................................hours
	unsigned ft_day   : 5;  //...........................................days
	unsigned ft_month : 4;  //.........................................months
	unsigned ft_year  : 7;  //....................................year - 1980
};

//............................................the assert macro implementation
#undef assert
#ifdef NDEBUG
	#define assert(p)   ((void)0)
#else
	#define assert(p) ((p) ? (void)0 : (void) __assertfail( \
	"assertion failed: %s, file %s, line %d\n", #p, __FILE__, __LINE__ ) )
#endif
//...................................missing constants for the open() routine
#define SH_DENYNO O_DENYNONE    //..........................deny noone access
#define SH_DENYWR O_DENYWRITE   //.....deny writing access to other processes
#define SH_DENYRW O_DENYALL     //............................deny any access
#define O_CREAT   0x0100        //..........if file does not exist, create it
#define O_TRUNC   0x0200        //................if file exists, truncate it

//............................these should be set at beginning of the program
extern unsigned int  _psp;     //..................the program segment prefix
extern unsigned char _osmajor; //.............................major version #
extern unsigned char _osminor; //.............................minor version #
extern unsigned int  _version; //..............................full version #

//..........................................CRTL routines with C linkage here
int      scanf( const char *format, ... );
int      sscanf( const char *buffer, const char *format, ... );
int      fscanf( FILE *stream, const char *format, ... );
int      vscanf( const char *format, va_list arglist );
int      vsscanf( const char *buffer, const char *format, va_list arglist );
int      vfscanf( FILE *stream, const char *format, va_list arglist );
char*    getcwd( char *path, int buflen );
int      setdisk( int drive );
int      getdisk( void );
void*    bsearch(const void *k, const void *b, size_t n, size_t w, fpCompFunc);
void     qsort(void *base, size_t n, size_t width, fpCompFunc);
int      bioskey(int command);
char*    mktemp(char *s);
int      chmod( const char *path, int amode );
long     tell( int handle );
int      eof( int handle );
void     sound( unsigned frequency );
void     nosound();
void     poke(unsigned segment, unsigned offset, int value);
void     pokeb(unsigned segment, unsigned offset, char value);
int      peek(unsigned segment, unsigned offset);
char     peekb(unsigned segment, unsigned offset);
void     interrupt (far *getvect(int intno))(__CPPARGS);
void     setvect(int intno, void interrupt (far *isr)(__CPPARGS));
int      fstat(int handle, struct stat *statbuf);
int      stat(char *path, struct stat *statbuf);
int      wherex( void );
int      wherey( void );
void     getdfree(unsigned char drive, struct dfree *dtable);
int      getftime(int handle, struct ftime *ftimep);
int      setftime(int handle, struct ftime *ftimep);
unsigned getpsp(void);
unsigned long coreleft(void);
int      _chmod(const char *path, int func, ... /*int attrib*/);
void     __assertfail( char *msg, char *cond, char *file, int line );
void     _dos_getdate( struct dosdate_t *datep );
void     _dos_gettime( struct dostime_t *timep );

//.............wrap the C linkage and have some special stuff for C++ linkage
#ifdef __cplusplus
	}
	// this here is the special version of open() - must have C++ linkage
	int  open(const char *p, int mode, unsigned shflag);
	void exit(int status);
#endif /* __cplusplus */

#endif /* PB_SDK */

#endif /* INCLUDED_PBLIBC_H */
