/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#ifndef INCLUDED_GREP_H
#define INCLUDED_GREP_H

/*
 * p a t t e r n   m a t c h i n g   p a c k a g e
 * 
 * string pattern matching, regular expression parser and wildcard globbers
*/
#define MAXPAT       512  //....maximum compiled pattern length, should be Ok
#define GREP_OK        0  //........................................no errors
#define GREP_BADESC    1  //.........the escape character was followed by EOS
#define GREP_OVRFLOW   2  //....pattern too complex, internal buffer overflow
#define GREP_BADSET    3  //............bad set specification, not terminated
#define GREP_BADPAT    4  //.........bad pattern, '*' or '+' not allowed here
#define GREP_BADSTAR   5  //......'*' followed another '*', error in globbing

extern int grepError;     //.........holds the error code if any grep failure

int   grep_compile( const char *pat );
char *grep_match( const char *line );
char *grep( const char *pat, const char *line );

int   glob_compile( const char *pat );
int   glob_match( const char *s );
int   glob( const char *pat, const char *s );

#endif /* INCLUDED_GREP_H */
