/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#ifndef INCLUDED_FBASE_H
#define INCLUDED_FBASE_H

/////////////////////////////////////////////////////////////////////////////
// proboard filebase-related classes (searching index, upload log processing)
/////////////////////////////////////////////////////////////////////////////
#include "typedef.h"

#ifndef PB_SDK
	#include <stdio.h>
	#include <time.h>
#else
	#include "pblibc.h"
#endif

/////////////////////////////////////////////////////////////////////////////
// class that searches for a file using proboard's file index (wildcards too)
/////////////////////////////////////////////////////////////////////////////
class zFileIndex
{
public:
	zFileIndex();
	~zFileIndex();

	short Find(char *name, const char *pattern = 0);
	void  Restart(){ if( m_fp ) rewind(m_fp); }

private:
	FILE    *m_fp;
	Boolean  m_init;
};

/////////////////////////////////////////////////////////////////////////////
// class which parses the standard user upload log created by proboard
/////////////////////////////////////////////////////////////////////////////
class zFileUpload
{
public:
	zFileUpload();
	~zFileUpload();

	Boolean Load(char *file = 0, struct tm *datep = 0, char *uploader = 0);
	void    Restart(){ if( m_fp ) rewind(m_fp); }

	const char*      GetFile() const;
	const char*      GetName() const;
	const struct tm* GetDate() const;

private:
	Boolean    m_found;
	FILE      *m_fp;
	char       m_file[13];
	char       m_name[36];
	struct tm  m_date;
};

#endif /* INCLUDED_FBASE_H */
